<?php

/**
 * @file
 * Definition of views_handler_field_relation_link.
 */

/**
 * Field handler to present a link to the relation.
 *
 * @ingroup views_field_handlers
 */
class views_handler_field_relation_link extends views_handler_field_entity {

  function option_definition() {
    $options = parent::option_definition();
    $options['text'] = array('default' => '', 'translatable' => TRUE);
    return $options;
  }

  function options_form(&$form, &$form_state) {
    $form['text'] = array(
      '#type' => 'textfield',
      '#title' => t('Text to display'),
      '#default_value' => $this->options['text'],
    );
    parent::options_form($form, $form_state);

    // The path is set by render_link function so don't allow to set it.
    $form['alter']['path'] = array('#access' => FALSE);
    $form['alter']['external'] = array('#access' => FALSE);
  }

  function render($values) {
    if ($entity = $this->get_value($values)) {
      return $this->render_link($entity, $values);
    }
  }

  function render_link($relation, $values) {
    // Ensure that relation_ui module enabled.
    if (!module_exists('relation_ui')) {
      return;
    }

    if (user_access('view relations')) {
      $this->options['alter']['make_link'] = TRUE;
      $relation_uri = entity_uri('relation', $relation);
      $this->options['alter']['path'] = $relation_uri['path'];
      $text = !empty($this->options['text']) ? $this->options['text'] : t('View');
      return $text;
    }
  }
}
