CREATE OR REPLACE FUNCTION check_size_%TABLE()
RETURNS TRIGGER AS
$body$
    BEGIN
        -- replace 100 by the number of rows you want
        IF (SELECT count(*) FROM ef_%TABLE) > %NUM THEN 
            RAISE EXCEPTION 'INSERT statement exceeding maximum number of rows for this table' ;
        END IF;
        return new;
    END;
$body$
LANGUAGE plpgsql;

CREATE TRIGGER tr_check_size_%TABLE 
BEFORE INSERT ON %TABLE
FOR EACH ROW EXECUTE PROCEDURE check_size_%TABLE();

