begin
  require 'gtk3'
rescue LoadError
  require 'gtk2'  
end


module Culter end
module Culter::Ensis

  class EnsisWindow < Gtk::Window
    def initialize(culter)
      super()
      @global_box = Gtk::VBox.new(false,0)
      self.add @global_box
      if self.respond_to? 'create_menu' then self.create_menu end
      @culter = culter
      self.create_all_components
    end
    
    def start
      self.show_all
      Gtk.main
    end
    
    def add_pane(name, box)
      box1 = Gtk::Frame.new(name)
      @global_box.add(box1)
      box1.add(box)
      return box1
    end    
  end
  
  # ------------------------------ Editor ------------------------

  class Editor < EnsisWindow
    def initialize(culter)
      super(culter)
      self.set_title('Segmentation Rules Editor' + (culter == nil ? '' : culter.name))
      self.signal_connect('destroy') { Gtk.main_quit }
    end
    
    def create_menu
      menubar = Gtk::MenuBar.new
      @global_box.pack_start( menubar, false, false, 0)
      menu1 = Gtk::MenuItem.new('Test')
      menubar.append menu1
      item1 = Gtk::MenuItem.new 'Test'
      item1.signal_connect("activate") { open_test }
      item2 = Gtk::MenuItem.new 'Save as'      
      item2.signal_connect("activate") { open_save }
      item3 = Gtk::MenuItem.new 'Quit'      
      item3.signal_connect("activate") { Gtk.main_quit }
      menu = Gtk::Menu.new
      menu.append item1; menu.append item2; menu.append item3
      menu1.set_submenu menu
    end
    def input_dialog(question)
        dialog = Gtk::MessageDialog.new(self, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
	     Gtk::MessageDialog::QUESTION,
             Gtk::MessageDialog::BUTTONS_OK_CANCEL,
             question)
        userEntry = Gtk::Entry.new
        userEntry.set_size_request(250,25)
        dialog.vbox.pack_end(userEntry, true, false, 0)
	dialog.show_all
	res = nil
	dialog.run do |response|
            if response == Gtk::Dialog::RESPONSE_OK
               res = userEntry.text
               dialog.destroy
	    else
               dialog.destroy
            end
	end
	return res
    end
    def open_save
       win =  Gtk::FileChooserDialog.new('Save file to...', self, 
           Gtk::FileChooser::ACTION_OPEN, nil,
            [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
            [Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
        do_save(win.filename) if win.run == Gtk::Dialog::RESPONSE_ACCEPT       
        win.close
    end
  end
  
  class OptionsBox < Gtk::VBox
    def initialize(culter)
      super()
      self.add(@cascade = box('Cascade', culter, 'cascade'))
      self.add(formats = Gtk::HBox.new)
      formats.add(Gtk::Label.new('Format handles: '))
      formats.add(@fmtStart = box('Start',culter, 'formatHandle.start'))
      formats.add(@fmtEnd = box('End', culter,'formatHandle.end'))
      formats.add(@fmtIsolated = box('Isolated', culter,'formatHandle.isolated'))
    end
    
    def box(title, culter, field)
      box = Gtk::CheckButton.new(title)
      if field =~ /^(.+)\.(.+)/
          box.active = culter.send($1)[$2]
          box.signal_connect('toggled') { culter.send($1)[$2] = box.active? }          
      else
          box.active = culter.send(field)
          box.signal_connect('toggled') { culter.send(field + '=', box.active?) }
      end
      return box
    end
  end
  
  class ButtonsViewBox < Gtk::HBox
    def initialize(window,culter)
      super()
      @window = window
      self.add(sp = Gtk::ScrolledWindow.new)
      sp.hscrollbar_policy = Gtk::PolicyType::NEVER
      sp.vscrollbar_policy = Gtk::PolicyType::AUTOMATIC
      sp.add(@view = create_view(culter))
      self.add(btnBox = Gtk::VBox.new)
      upDown_buttons.each { |btn| btnBox.add(btn) } 
      btnBox.add(@btnAdd = Gtk::Button.new('Add'))
      btnBox.add(@btnEdit = Gtk::Button.new('Edit'))
      @btnAdd.signal_connect('clicked') { action_add }
      @btnEdit.signal_connect('clicked') { action_edit }
      btnBox.add(btnRemove = Gtk::Button.new('Remove'))
      btnRemove.signal_connect('clicked') do 
        dialog = Gtk::MessageDialog.new(nil, 
            Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT, Gtk::MessageDialog::QUESTION, Gtk::MessageDialog::BUTTONS_OK_CANCEL,
             'Are you sure?')
        dialog.run do |response|
            do_remove() if response == Gtk::Dialog::RESPONSE_OK 
            dialog.destroy
        end
      end
      @selectedItem = nil; @btnEdit.sensitive = false; @view.selection.signal_connect('changed') { |s| @btnEdit.sensitive = true; @selectedItem = s.selected }      
    end
    def do_remove() 
        @view.remove!(selectedIndex)
        array = ordered_array()
        self.instance_variable_get(array).delete_at(selectedIndex) unless array == nil
    end
    def upDown_buttons()
        array = ordered_array()
        return [] unless array != nil
        
        btnUp = Gtk::Button.new('↑ Move up')
        btnUp.sensitive = (selectedIndex > 0)
        btnUp.signal_connect('clicked') do 
           idx = selectedIndex
           @view.move!(selectedIndex, -1)
           ref = self.instance_variable_get(array); el = ref[idx]; ref.delete_at(idx); ref.insert(idx - 1, el)
        end
        btnDown = Gtk::Button.new('↓ Move down')
        btnDown.sensitive = (selectedIndex >= 0)
        btnDown.signal_connect('clicked') do 
           idx = selectedIndex
           @view.move!(selectedIndex, +1)
           ref = self.instance_variable_get(array); el = ref[idx]; ref.delete_at(idx); ref.insert(idx + 1, el) 
        end
        @view.selection.signal_connect('changed') do |s|  
            @selectedItem = s.selected
            btnUp.sensitive = (selectedIndex > 0) 
            btnDown.sensitive = (selectedIndex >= 0) 
        end
        return [ btnUp, btnDown ]
    end
  end
  
  class RulesMappingView < Gtk::TreeView
    def initialize(culter)
      super(@model = Gtk::ListStore.new(String,String))
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      append_column Gtk::TreeViewColumn.new("Expression",renderer)
      columns[0].add_attribute renderer, "text", 0
      append_column Gtk::TreeViewColumn.new("Name",renderer)
      columns[1].add_attribute renderer, "text", 1
      @model.clear; @rows = []
      culter.defaultMapRule.each { |mr| add_to_view(mr) }
      self.expand_all    
    end
    def refresh_item(idx,mr)
        row = @rows[idx]
        row[0] = mr.pattern.to_s
        row[1] = mr.rulename    
    end
    def add_to_view(mr) 
        @rows << (row = @model.append)
        row[0] = mr.pattern.to_s
        row[1] = mr.rulename
    end
    def move!(idx,count) 
        @model.swap(@rows[idx],@rows[idx + count]) 
        tmp = @rows[idx]; @rows[idx] = @rows[idx + count]; @rows[idx + count] = tmp
    end
    def remove!(idx) @model.remove(@rows[idx]); @rows.delete_at(idx) end
  end
  
  class RulesMappingBox < ButtonsViewBox
    def initialize(window,culter)
      super(window,culter)
      @mapRule = culter.defaultMapRule
      @langRules = culter.langRules
    end
    def create_view(culter) return RulesMappingView.new(culter) end
    def ordered_array() true end
    def refresh_item(idx,mr) @view.refresh_item(idx,mr) end
    def add_to_view(mr) @view.add_to_view(mr) end
    def selectedIndex() @selectedItem.to_s.to_i end
  end
  
  class MappingEditDialog < Gtk::Dialog 
    def initialize(parent,langRules,maprule,mapping)
      super(mapping == nil ? 'New mapping' : 'Edit mapping', parent, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])      
      vbox.add(panel1 = Gtk::HBox.new)
      panel1.add(Gtk::Label.new('Language (expression): '))
      panel1.add(@langBox = Gtk::Entry.new)
      vbox.add(panel2 = Gtk::HBox.new)
      panel2.add(@rbExisting = Gtk::RadioButton.new('Existing language rule: '))
      panel2.add(@cbExisting = Gtk::ComboBox.new())
      langRules.each { |k,v| @cbExisting.append_text(k) }
      panel2.add(@btnEditExisting = Gtk::Button.new('Edit'))
      @btnEditExisting.signal_connect('clicked') { dial = LangRuleEditDialog.new(self,@cbExisting.active_text,langRules[@cbExisting.active_text]); dial.action! }
      vbox.add(panel3 = Gtk::HBox.new)      
      panel3.add(@rbNewMapping = Gtk::RadioButton.new('New language rule: '))
      panel3.add(@txtNewMappingName = Gtk::Entry.new)
      panel3.add(@btnEditNew = Gtk::Button.new('Edit'))
      @btnEditNew.signal_connect('clicked') { dial = LangRuleEditDialog.new(self,@txtNewMappingName.text,[]); dial.action! }
      @rbNewMapping.group = @rbExisting.group[0]
      @rbExisting.signal_connect('toggled') { @cbExisting.sensitive = @btnEditExisting.sensitive = true; @txtNewMappingName.sensitive = @btnEditNew.sensitive = false }
      @rbNewMapping.signal_connect('toggled') { @cbExisting.sensitive = @btnEditExisting.sensitive = false; @txtNewMappingName.sensitive = @btnEditNew.sensitive = true }
      if mapping != nil then
          @mapping = mapping
          @rbExisting.active = true
          idx = 0; langRules.each { |k,v| @cbExisting.active = idx if k == mapping.rulename; idx = idx + 1 }
          @cbExisting.sensitive = @btnEditExisting.sensitive = true; @txtNewMappingName.sensitive = @btnEditNew.sensitive = false
          @langBox.text = mapping.pattern.to_s	
      else
          @rbNewMapping.active = true
          @cbExisting.sensitive = @btnEditExisting.sensitive = false; @txtNewMappingName.sensitive = @btnEditNew.sensitive = true
      end
    end
    
    attr_reader :mapping
    def action!()
        show_all
        run do |response|
            if response == Gtk::Dialog::RESPONSE_ACCEPT then 
                if @rbNewMapping.active? then
                    @mapping = Culter::SRX::LangMap.new(Regexp.new(@langBox.text), @txtNewMappingName.text)
                else
                    @mapping = Culter::SRX::LangMap.new(Regexp.new(@langBox.text), @cbExisting.active_text)	  
                end
            else
                @mapping = nil
            end
            destroy
        end    
    end
  end  
  
  class LangRuleEditDialog < Gtk::Dialog 
    def initialize(parent,name,langRule)
      super(name, parent, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])      
      vbox.add(@view = LangRuleView.new(parent,langRule))
    end
    def action!()
        show_all
	run do |response|
        #    if response == Gtk::Dialog::RESPONSE_ACCEPT then 
	#      
	#    else
	#      @mapping = nil
	#    end
            destroy
	end    
    end
  end  
  
  class LangRuleView < ButtonsViewBox
    def initialize(window,langRule)
      super(window,langRule)
    end
    def create_view(langRule)
      @model = Gtk::ListStore.new(String, String,String,String)
      @langRule = langRule
      langRule.each { |item| add_to_view(item) }
      tw = Gtk::TreeView.new(@model)    
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      tw.append_column Gtk::TreeViewColumn.new("Type",renderer)
      tw.columns[0].add_attribute renderer, "text", 0
      tw.append_column Gtk::TreeViewColumn.new("Before",renderer)
      tw.columns[1].add_attribute renderer, "text", 1      
      tw.append_column Gtk::TreeViewColumn.new("After",renderer)
      tw.columns[2].add_attribute renderer, "text", 2
      tw.append_column Gtk::TreeViewColumn.new("Name",renderer)
      tw.columns[3].add_attribute renderer, "text", 3 
      return tw
    end
    def selectedIndex()  @selectedItem.to_s.to_i end
    def add_to_view(rule) 
        row = @model.append
         if rule.is_a? Culter::SRX::Rule then
             row[0] = rule.break ? 'Break rule' : 'Exception rule'
             row[1] = rule.before.to_s
             row[2] = rule.after.to_s
             row[3] = rule.ruleName
         elsif rule.is_a? Culter::CSC::ApplyRuleTemplate then
             row[0] = 'Apply template'
             row[1] = ''
             row[2] = ''
             row[3] = rule.name
         end
    end
  end  
  
  class TemplatesView < Gtk::TreeView
    def initialize(culter)
      super(@model = Gtk::ListStore.new(String))
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      append_column Gtk::TreeViewColumn.new("Name",renderer)
      columns[0].add_attribute renderer, "text", 0
      @model.clear
      if culter.respond_to? 'ruleTemplates'
	 @map = culter.ruleTemplates
         culter.ruleTemplates.each do |name,rule| 
	   row = @model.append
	   row[0] = name
	 end
      else
	 @map = {}
      end
      self.expand_all    
    end    
    attr_reader :map
  end  

  class TemplatesBox < ButtonsViewBox
    def initialize(window,culter)
      super(window,culter)
      @map = @view.map
    end
    def add_to_view(rule) row = @view.model.append; row[0] = rule.ruleName; end
    def create_view(culter) return TemplatesView.new(culter) end
    def ordered_array() false end
    def selectedItem() @selectedItem[0] end
  end
  
  class RuleEditDialog < Gtk::Dialog    
    def initialize(window,rule)
      super(rule == nil ? 'New rule' : 'Edit rule', window, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])      
      vbox.add(panel1 = Gtk::HBox.new)
      panel1.add(@rbBreak = Gtk::RadioButton.new('Break'))
      panel1.add(@rbException = Gtk::RadioButton.new('Exception')) 
      @rbException.group = @rbBreak.group[0]
      vbox.add(panel2 = Gtk::HBox.new)
      panel2.add(Gtk::Label.new('Before: '))
      panel2.add(@beforeBox = Gtk::Entry.new)
      vbox.add(panel3 = Gtk::HBox.new)
      panel3.add(Gtk::Label.new('After: '))
      panel3.add(@afterBox = Gtk::Entry.new)
      vbox.add(panel4 = Gtk::HBox.new)
      panel4.add(Gtk::Label.new('Rule name: '))
      panel4.add(@nameBox = Gtk::Entry.new)
      if rule != nil then
          @rule = rule
          @nameBox.sensitive = false; if rule.respond_to? 'name' then @nameBox.text = rule.name else @rule.ruleName end
          if rule.respond_to? 'rewriteRule' then rule = rule.rewriteRule end
          if rule.break then @rbBreak.active = true else @rbException.active = true end 
          @beforeBox.text = rule.before; @afterBox.text = rule.after
      else
          @rbBreak.active = true
          #okBtn.sensitive = nameBox.text.length > 0; nameBox.signal_connect('changed') { okBtn.sensitive = nameBox.text.length > 0 }
      end
    end
  
    attr_reader :rule    
    def action!()
        show_all
        run do |response|
            if response == Gtk::Dialog::RESPONSE_ACCEPT then 
                @rule = Culter::SRX::Rule.new(@rbBreak.active?, @nameBox.text)
                @rule.before = @beforeBox.text; @rule.after = @afterBox.text
            else
                @rule = nil
            end
            destroy
        end    
    end
  end
  
  class ApplyTemplateView < ButtonsViewBox
    def initialize(window,tab)
        super(window,tab)
    end
    def create_view(tab)
        @model = Gtk::ListStore.new(String)
        @model.clear
        tab.each { |item| row = @model.append ; row[0] = item }
        res = Gtk::TreeView.new(@model)
        renderer = Gtk::CellRendererText.new
        renderer.set_property 'yalign', 0		# align to top
        res.append_column Gtk::TreeViewColumn.new("Name",renderer)
        res.columns[0].add_attribute renderer, "text", 0
        return res
    end    
    def ordered_array() nil end
    def selectedItem() @selectedItem[0] end
  end
  
  class ApplyTemplateEditDialog < Gtk::Dialog    
    def initialize(window,rule)
      super(rule == nil ? 'New rule' : 'Edit rule', window, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])            
      vbox.add(panel1 = Gtk::HBox.new)
      panel1.add(Gtk::Label.new('Template: '))
      panel1.add(@tplBox = Gtk::Entry.new)
      @tplBox.text = rule.name
      @paramBoxes = {}
      rule.params.each do |name,vals|
         vbox.add(Gtk::Label.new("Parameter '#{name}'"))
         vbox.add(@paramBoxes[name] = ApplyTemplateView.new(window,vals))         
      end
    end
  
    attr_reader :rule    
    def action!()
        show_all
        run do |response|
            if response == Gtk::Dialog::RESPONSE_ACCEPT then 
                @rule = Culter::SRX::Rule.new(@rbBreak.active?, @nameBox.text)
                @rule.before = @beforeBox.text; @rule.after = @afterBox.text
            else
                @rule = nil
            end
            destroy
        end    
    end
  end

  
  # ------------------------------ Tester ------------------------
  
  class Tester < EnsisWindow
    def initialize(culter)
      super(culter)
      self.set_title('Segmentation Rules Tester - ' + culter.name)
      self.set_default_size(300,500)
    end
  end
  
  class TextBox < Gtk::Frame
    def initialize(culter,resultBox)
      super()      
      self.add(textBox = Gtk::TextView.new)
      textBox.buffer.signal_connect('changed') { resultBox.setContents(DebugLine.cut_debug(culter, textBox.buffer.text)) } 
      textBox.wrap_mode = :word
    end
    
  end
  
  class ResultBox < Gtk::Frame
    def initialize
      super()
      @model = Gtk::ListStore.new(Integer, String,String)
      self.add(@view = Gtk::TreeView.new(@model))
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top      
      renderer.set_property 'wrap_mode',  :word
      renderer.set_property 'wrap_width',  250
      @view.append_column Gtk::TreeViewColumn.new("Number",renderer)
      @view.append_column Gtk::TreeViewColumn.new("Segment",renderer)
      @view.append_column Gtk::TreeViewColumn.new("Rules",renderer)
      @view.columns[0].fixed_width = 50; @view.columns[0].add_attribute renderer, "text", 0
      @view.columns[1].fixed_width = 250; @view.columns[1].sizing = Gtk::TreeViewColumn::FIXED; @view.columns[1].add_attribute renderer, "text", 1      
      @view.columns[2].fixed_width = 100; @view.columns[2].add_attribute renderer, "text", 2      
    end
    
    def setContents(split)
      @model.clear
      i = 0
      split.each do |segment|
	row = @model.append
	i = i + 1; row[0] = i
	row[1] = segment.phrase_with_mark("\u2316")
	row[2] = segment.rules.join("\r\n")	
      end
      @view.expand_all
    end    
  end


  
end

