/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.util.bind;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.loomchild.maligna.util.ResourceNotFoundException;
import net.loomchild.maligna.util.Util;
import net.loomchild.maligna.util.bind.BindException;
import net.loomchild.maligna.util.bind.QuietValidationEventHandler;
import org.xml.sax.SAXException;

public class MarshallerUnmarshaller {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallerUnmarshaller(String context, String[] schemaNameArray) {
        try {
            ArrayList<StreamSource> sourceList = new ArrayList<StreamSource>();
            for (String schemaName : schemaNameArray) {
                InputStream schemaStream = Util.getResourceStream(schemaName);
                sourceList.add(new StreamSource(schemaStream));
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(sourceList.toArray(new Source[0]));
            JAXBContext jaxbcontext = JAXBContext.newInstance((String)context);
            this.unmarshaller = jaxbcontext.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new QuietValidationEventHandler());
            this.marshaller = jaxbcontext.createMarshaller();
            this.marshaller.setSchema(schema);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException e) {
            throw new BindException("JAXB error", e);
        }
        catch (SAXException e) {
            throw new BindException("Error parsing XML Schema", e);
        }
        catch (ResourceNotFoundException e) {
            throw new BindException("Resource not found", e);
        }
    }

    public MarshallerUnmarshaller(String context, String schemaName) {
        this(context, new String[]{schemaName});
    }

    public void marshal(Object object, Writer writer) {
        try {
            this.marshaller.marshal(object, writer);
        }
        catch (JAXBException e) {
            throw new BindException("JAXB marshalling error", e);
        }
    }

    public Object unmarshal(Reader reader) {
        try {
            return this.unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new BindException("JAXB unmarshalling error", e);
        }
    }
}

