/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXReader2;
import org.omegat.util.TMXWriter2;

public class ProjectTMX {
    protected static final String PROP_FILE = "file";
    protected static final String PROP_ID = "id";
    protected static final String PROP_PREV = "prev";
    protected static final String PROP_NEXT = "next";
    protected static final String PROP_PATH = "path";
    protected static final String PROP_XICE = "x-ice";
    protected static final String PROP_X100PC = "x-100pc";
    protected static final String PROP_XAUTO = "x-auto";
    Map<String, TMXEntry> defaults;
    Map<EntryKey, TMXEntry> alternatives;
    final CheckOrphanedCallback checkOrphanedCallback;

    public ProjectTMX(Language sourceLanguage, Language targetLanguage, boolean isSentenceSegmentingEnabled, File file, CheckOrphanedCallback callback) throws Exception {
        this.checkOrphanedCallback = callback;
        this.alternatives = new HashMap<EntryKey, TMXEntry>();
        this.defaults = new HashMap<String, TMXEntry>();
        if (file == null || !file.exists()) {
            return;
        }
        new TMXReader2().readTMX(file, sourceLanguage, targetLanguage, isSentenceSegmentingEnabled, false, true, Preferences.isPreference("ext_tmx_use_slash"), new Loader(sourceLanguage, targetLanguage, isSentenceSegmentingEnabled));
    }

    public ProjectTMX() {
        this.alternatives = new HashMap<EntryKey, TMXEntry>();
        this.defaults = new HashMap<String, TMXEntry>();
        this.checkOrphanedCallback = null;
    }

    public boolean isEmpty() {
        return this.defaults.isEmpty() && this.alternatives.isEmpty();
    }

    public void save(ProjectProperties props, String translationFile, boolean translationUpdatedByUser) throws Exception {
        if (!translationUpdatedByUser && new File(translationFile).exists()) {
            Log.logInfoRB("LOG_DATAENGINE_SAVE_NONEED", new Object[0]);
            return;
        }
        File newFile = new File(translationFile + ".new");
        this.exportTMX(props, newFile, false, false, true);
        File backup = new File(translationFile + ".bak");
        File orig = new File(translationFile);
        if (backup.exists() && !backup.delete()) {
            throw new IOException("Error delete backup file");
        }
        if (orig.exists()) {
            FileUtil.rename(orig, backup);
        }
        FileUtil.rename(newFile, orig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTMX(ProjectProperties props, File outFile, boolean forceValidTMX, boolean levelTwo, boolean useOrphaned) throws Exception {
        try (TMXWriter2 wr = new TMXWriter2(outFile, props.getSourceLanguage(), props.getTargetLanguage(), props.isSentenceSegmentingEnabled(), levelTwo, forceValidTMX);){
            TreeMap<String, TMXEntry> tempDefaults = new TreeMap<String, TMXEntry>();
            TreeMap<EntryKey, TMXEntry> tempAlternatives = new TreeMap<EntryKey, TMXEntry>();
            ProjectTMX projectTMX = this;
            synchronized (projectTMX) {
                if (useOrphaned) {
                    tempDefaults.putAll(this.defaults);
                    tempAlternatives.putAll(this.alternatives);
                } else {
                    for (Map.Entry<String, TMXEntry> entry : this.defaults.entrySet()) {
                        if (!this.checkOrphanedCallback.existSourceInProject(entry.getKey())) continue;
                        tempDefaults.put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<Object, TMXEntry> entry : this.alternatives.entrySet()) {
                        if (!this.checkOrphanedCallback.existEntryInProject((EntryKey)entry.getKey())) continue;
                        tempAlternatives.put((EntryKey)entry.getKey(), entry.getValue());
                    }
                }
            }
            ArrayList<String> p = new ArrayList<String>();
            wr.writeComment(" Default translations ");
            for (Map.Entry<Object, TMXEntry> entry : new TreeMap(tempDefaults).entrySet()) {
                p.clear();
                if (Preferences.isPreferenceDefault("save_auto_status", false) && entry.getValue().linked == TMXEntry.ExternalLinked.xAUTO) {
                    p.add(PROP_XAUTO);
                    p.add("auto");
                }
                wr.writeEntry((String)entry.getKey(), entry.getValue().translation, entry.getValue(), p);
            }
            wr.writeComment(" Alternative translations ");
            for (Map.Entry<Object, TMXEntry> entry : new TreeMap(tempAlternatives).entrySet()) {
                EntryKey k = (EntryKey)entry.getKey();
                p.clear();
                p.add(PROP_FILE);
                p.add(k.file);
                p.add(PROP_ID);
                p.add(k.id);
                p.add(PROP_PREV);
                p.add(k.prev);
                p.add(PROP_NEXT);
                p.add(k.next);
                p.add(PROP_PATH);
                p.add(k.path);
                if (Preferences.isPreferenceDefault("save_auto_status", false)) {
                    if (entry.getValue().linked == TMXEntry.ExternalLinked.xICE) {
                        p.add(PROP_XICE);
                        p.add(k.id);
                    } else if (entry.getValue().linked == TMXEntry.ExternalLinked.x100PC) {
                        p.add(PROP_X100PC);
                        p.add(k.id);
                    }
                }
                wr.writeEntry(((EntryKey)entry.getKey()).sourceText, entry.getValue().translation, entry.getValue(), p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMXEntry getDefaultTranslation(String source) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            return this.defaults.get(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMXEntry getMultipleTranslation(EntryKey ek) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            return this.alternatives.get(ek);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            if (te == null) {
                if (isDefault) {
                    this.defaults.remove(ste.getKey().sourceText);
                } else {
                    this.alternatives.remove(ste.getKey());
                }
            } else {
                if (!ste.getSrcText().equals(te.source)) {
                    throw new IllegalArgumentException("Source must be the same as in SourceTextEntry");
                }
                if (isDefault != te.defaultTranslation) {
                    throw new IllegalArgumentException("Default/alternative must be the same");
                }
                if (isDefault) {
                    this.defaults.put(ste.getKey().sourceText, te);
                } else {
                    this.alternatives.put(ste.getKey(), te);
                }
            }
        }
    }

    private TMXEntry.ExternalLinked calcExternalLinkedMode(PrepareTMXEntry te) {
        String id = te.getPropValue(PROP_ID);
        TMXEntry.ExternalLinked externalLinked = null;
        if (externalLinked == null && te.hasPropValue(PROP_XICE, id)) {
            externalLinked = TMXEntry.ExternalLinked.xICE;
        }
        if (externalLinked == null && te.hasPropValue(PROP_X100PC, id)) {
            externalLinked = TMXEntry.ExternalLinked.x100PC;
        }
        if (externalLinked == null && te.hasPropValue(PROP_XAUTO, null)) {
            externalLinked = TMXEntry.ExternalLinked.xAUTO;
        }
        return externalLinked;
    }

    public Collection<TMXEntry> getDefaults() {
        return this.defaults.values();
    }

    public Collection<TMXEntry> getAlternatives() {
        return this.alternatives.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContent(ProjectTMX tmx) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            this.defaults = tmx.defaults;
            this.alternatives = tmx.alternatives;
        }
    }

    public String toString() {
        return "[" + Stream.concat(this.defaults.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + ": " + ((TMXEntry)e.getValue()).translation), this.alternatives.entrySet().stream().sorted(Comparator.comparing(e -> ((EntryKey)e.getKey()).sourceText)).map(e -> ((EntryKey)e.getKey()).sourceText + ": " + ((TMXEntry)e.getValue()).translation)).collect(Collectors.joining(", ")) + "]";
    }

    public static interface CheckOrphanedCallback {
        public boolean existEntryInProject(EntryKey var1);

        public boolean existSourceInProject(String var1);
    }

    private class Loader
    implements TMXReader2.LoadCallback {
        private final Language sourceLang;
        private final Language targetLang;
        private final boolean sentenceSegmentingEnabled;

        Loader(Language sourceLang, Language targetLang, boolean sentenceSegmentingEnabled) {
            this.sourceLang = sourceLang;
            this.targetLang = targetLang;
            this.sentenceSegmentingEnabled = sentenceSegmentingEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
            if (tuvSource == null) {
                return false;
            }
            String creator = null;
            long created = 0L;
            String changer = null;
            long changed = 0L;
            String translation = null;
            if (tuvTarget != null) {
                creator = StringUtil.nvl(tuvTarget.creationid, tu.creationid);
                created = StringUtil.nvlLong(tuvTarget.creationdate, tu.creationdate);
                changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                changed = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                translation = tuvTarget.text;
            }
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList<String> targets = new ArrayList<String>();
            Core.getSegmenter().segmentEntries(this.sentenceSegmentingEnabled && isParagraphSegtype, this.sourceLang, tuvSource.text, this.targetLang, translation, sources, targets);
            Loader loader = this;
            synchronized (loader) {
                for (int i = 0; i < sources.size(); ++i) {
                    boolean defaultTranslation;
                    String segmentSource = (String)sources.get(i);
                    String segmentTranslation = (String)targets.get(i);
                    PrepareTMXEntry te = new PrepareTMXEntry();
                    te.source = segmentSource;
                    te.translation = segmentTranslation;
                    te.changer = changer;
                    te.changeDate = changed;
                    te.creator = creator;
                    te.creationDate = created;
                    te.note = tu.note;
                    te.otherProperties = tu.props;
                    EntryKey key = new EntryKey(te.getPropValue(ProjectTMX.PROP_FILE), te.source, te.getPropValue(ProjectTMX.PROP_ID), te.getPropValue(ProjectTMX.PROP_PREV), te.getPropValue(ProjectTMX.PROP_NEXT), te.getPropValue(ProjectTMX.PROP_PATH));
                    TMXEntry.ExternalLinked externalLinkedMode = ProjectTMX.this.calcExternalLinkedMode(te);
                    boolean bl = defaultTranslation = key.file == null;
                    if (te.otherProperties != null && te.otherProperties.isEmpty()) {
                        te.otherProperties = null;
                    }
                    if (defaultTranslation) {
                        ProjectTMX.this.defaults.put(segmentSource, new TMXEntry(te, true, externalLinkedMode));
                        continue;
                    }
                    ProjectTMX.this.alternatives.put(key, new TMXEntry(te, false, externalLinkedMode));
                }
            }
            return true;
        }
    }
}

