/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.IssueDetailSplitPanel;
import org.omegat.gui.issues.SimpleColorIcon;

public abstract class SimpleIssue
implements IIssue {
    private final SourceTextEntry sourceEntry;
    private final TMXEntry targetEntry;
    private final Icon icon;

    public SimpleIssue(SourceTextEntry sourceEntry, TMXEntry targetEntry) {
        this.sourceEntry = sourceEntry;
        this.targetEntry = targetEntry;
        this.icon = new SimpleColorIcon(this.getColor());
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    protected abstract String getColor();

    @Override
    public int getSegmentNumber() {
        return this.sourceEntry.entryNum();
    }

    @Override
    public Component getDetailComponent() {
        IssueDetailSplitPanel panel = new IssueDetailSplitPanel();
        panel.firstTextPane.setText(this.sourceEntry.getSrcText());
        panel.lastTextPane.setText(this.targetEntry.translation);
        panel.setMinimumSize(new Dimension(0, panel.firstTextPane.getFont().getSize() * 6));
        return panel;
    }
}

