/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.matching.external.SingletonMemories;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.matches.FindMatchesThread;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.gui.preferences.PreferencesWindowController;
import org.omegat.gui.preferences.view.TMMatchesPreferencesController;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Java8Compat;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MatchesTextArea
extends EntryInfoThreadPane<List<NearString>>
implements IMatcher,
IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_MATCHWINDOW_explanation");
    private static final AttributeSet ATTRIBUTES_EMPTY = Styles.createAttributeSet(null, null, null, null);
    private static final AttributeSet ATTRIBUTES_CHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_CHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_UNCHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_UNCHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_SELECTED = Styles.createAttributeSet(null, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_ACTIVE.getColor(), null, true, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_INACTIVE.getColor(), null, null, null, true, null);
    private static final AttributeSet ATTRIBUTES_INSERTED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_ACTIVE.getColor(), null, true, null, null, true);
    private static final AttributeSet ATTRIBUTES_INSERTED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_INACTIVE.getColor(), null, null, null, null, true);
    private final DockableScrollPane scrollPane;
    private final List<NearString> matches = new ArrayList<NearString>();
    private final List<Integer> delimiters = new ArrayList<Integer>();
    private final List<Integer> sourcePos = new ArrayList<Integer>();
    private final List<Map<Integer, List<DiffDriver.TextRun>>> diffInfos = new ArrayList<Map<Integer, List<DiffDriver.TextRun>>>();
    private int activeMatch = -1;
    protected final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() > 1) {
                MatchesTextArea.this.setActiveMatch(this.getClickedItem(e.getPoint()));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        private int getClickedItem(Point p) {
            if (MatchesTextArea.this.matches == null || MatchesTextArea.this.matches.isEmpty()) {
                return -1;
            }
            int clickedItem = -1;
            int mousepos = Java8Compat.viewToModel(MatchesTextArea.this, p);
            for (int i = 0; i < MatchesTextArea.this.delimiters.size() - 1; ++i) {
                int start = (Integer)MatchesTextArea.this.delimiters.get(i);
                int end = (Integer)MatchesTextArea.this.delimiters.get(i + 1);
                if (mousepos < start || mousepos >= end) continue;
                clickedItem = i;
                break;
            }
            if (clickedItem == -1) {
                clickedItem = MatchesTextArea.this.delimiters.size() - 1;
            }
            if (clickedItem >= MatchesTextArea.this.matches.size()) {
                return -1;
            }
            return clickedItem;
        }

        private void doPopup(Point p) {
            int clickedItem = this.getClickedItem(p);
            if (clickedItem == -1) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            MatchesTextArea.this.populateContextMenu(popup, clickedItem);
            popup.show(MatchesTextArea.this, p.x, p.y);
        }
    };

    public MatchesTextArea(IMainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches");
        this.scrollPane = new DockableScrollPane("MATCHES", title, this, true);
        mw.addDockable(this.scrollPane);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        ArrayList list = new ArrayList();
        for (Class<?> mtc : PluginUtils.getTranslationMemoryClasses()) {
            try {
                SingletonMemories.add((IExternalMemory)mtc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.addMouseListener(this.mouseListener);
        DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(false){

            @Override
            public String getImportDestination() {
                return Core.getProject().getProjectProperties().getTMRoot();
            }

            @Override
            public boolean acceptFile(File pathname) {
                return pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".tmx");
            }

            @Override
            public String getOverlayMessage() {
                return OStrings.getString("DND_ADD_TM_FILE");
            }

            @Override
            public boolean canAcceptDrop() {
                return Core.getProject().isProjectLoaded();
            }

            @Override
            public Component getComponentToOverlay() {
                return MatchesTextArea.this.scrollPane;
            }
        });
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.scrollPane.stopNotifying();
        super.onEntryActivated(newEntry);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindMatchesThread(this, Core.getProject(), newEntry).start();
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<NearString> newMatches) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (newMatches == null) {
            return;
        }
        if (!newMatches.isEmpty() && Preferences.isPreference("notify_fuzzy_matches")) {
            this.scrollPane.notify(true);
        }
        NearString.SORT_KEY key = Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", NearString.SORT_KEY.SCORE);
        newMatches.sort(Comparator.comparing(ns -> ns.scores[0], new NearString.ScoresComparator(key).reversed()));
        this.matches.addAll(newMatches);
        this.delimiters.add(0);
        StringBuilder displayBuffer = new StringBuilder();
        MatchesVarExpansion template = new MatchesVarExpansion(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        for (int i = 0; i < newMatches.size(); ++i) {
            NearString match = newMatches.get(i);
            MatchesVarExpansion.Result result = template.apply(match, i + 1);
            displayBuffer.append(result.text);
            this.sourcePos.add(result.sourcePos);
            this.diffInfos.add(result.diffInfo);
            if (i < newMatches.size() - 1) {
                displayBuffer.append("\n\n");
            }
            this.delimiters.add(displayBuffer.length());
        }
        this.setText(displayBuffer.toString());
        this.setActiveMatch(0);
        this.checkForReplaceTranslation();
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
    }

    @Override
    public NearString getActiveMatch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.activeMatch < 0 || this.activeMatch >= this.matches.size()) {
            return null;
        }
        return this.matches.get(this.activeMatch);
    }

    @Override
    public String substituteNumbers(String source, String sourceMatch, String targetMatch) {
        ITokenizer sourceTok = Core.getProject().getSourceTokenizer();
        ITokenizer targetTok = Core.getProject().getTargetTokenizer();
        return MatchesTextArea.substituteNumbers(source, sourceMatch, targetMatch, sourceTok, targetTok);
    }

    static String substituteNumbers(String source, String sourceMatch, String targetMatch, ITokenizer sourceTok, ITokenizer targetTok) {
        List sourceMatchNumbers = Stream.of(sourceTok.tokenizeVerbatimToStrings(sourceMatch)).filter(MatchesTextArea::isNumber).collect(Collectors.toList());
        String[] targetTokens = targetTok.tokenizeVerbatimToStrings(targetMatch);
        List targetMatchNumbers = Stream.of(targetTokens).filter(MatchesTextArea::isNumber).collect(Collectors.toList());
        List sourceNumbers = Stream.of(sourceTok.tokenizeVerbatimToStrings(source)).filter(MatchesTextArea::isNumber).collect(Collectors.toList());
        if (sourceMatchNumbers.size() != sourceNumbers.size() || sourceMatchNumbers.size() != targetMatchNumbers.size() || !new HashSet(sourceMatchNumbers).equals(new HashSet(targetMatchNumbers))) {
            return targetMatch;
        }
        Map<Integer, Integer> locationMap = MatchesTextArea.mapIndices(sourceMatchNumbers, targetMatchNumbers);
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (String tok : targetTokens) {
            if (MatchesTextArea.isNumber(tok)) {
                result.append((String)sourceNumbers.get(locationMap.get(i)));
                ++i;
                continue;
            }
            result.append(tok);
        }
        return result.toString();
    }

    private static boolean isNumber(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    private static Map<Integer, Integer> mapIndices(List<?> source, List<?> target) {
        if (source.size() != target.size()) {
            throw new IllegalArgumentException("Lists must be the same size");
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        block0: for (int i = 0; i < source.size(); ++i) {
            for (int j = 0; j < target.size(); ++j) {
                Object trg;
                Object src = source.get(i);
                if (src != (trg = target.get(j)) && !src.equals(trg) || result.values().contains(j)) continue;
                result.put(i, j);
                continue block0;
            }
        }
        return result;
    }

    private void checkForReplaceTranslation() {
        if (this.matches.isEmpty()) {
            return;
        }
        if (Preferences.isPreference("wf_insertBestMatch")) {
            int percentage = Preferences.getPreferenceDefault("wf_minimalSimilarity", 80);
            NearString thebest = this.matches.get(0);
            if (thebest.scores[0].score >= percentage) {
                SourceTextEntry currentEntry = Core.getEditor().getCurrentEntry();
                TMXEntry te = Core.getProject().getTranslationInfo(currentEntry);
                if (!te.isTranslated()) {
                    String prefix = "";
                    if (!Preferences.getPreference("wf_explanatoryText").isEmpty()) {
                        prefix = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX"));
                    }
                    String translation = thebest.translation;
                    if (Preferences.isPreference("wf_convertNumbers")) {
                        translation = this.substituteNumbers(currentEntry.getSrcText(), thebest.source, thebest.translation);
                    }
                    Core.getEditor().replaceEditText(prefix + translation);
                }
            }
        }
    }

    @Override
    public void setActiveMatch(int activeMatch) {
        UIThreadsUtil.mustBeSwingThread();
        if (activeMatch < 0 || activeMatch >= this.matches.size() || this.activeMatch == activeMatch) {
            return;
        }
        this.activeMatch = activeMatch;
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
        int start = this.delimiters.get(activeMatch);
        int end = this.delimiters.get(activeMatch + 1);
        NearString match = this.matches.get(activeMatch);
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        if (tokenizer == null) {
            return;
        }
        if (this.sourcePos.get(activeMatch) != -1) {
            Token[] tokens = tokenizer.tokenizeVerbatim(match.source);
            byte[] attributes = match.attr;
            for (int i = 0; i < tokens.length; ++i) {
                Token token = tokens[i];
                int tokstart = start + this.sourcePos.get(activeMatch) + token.getOffset();
                int toklength = token.getLength();
                if ((attributes[i] & 1) != 0) {
                    doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_CHANGED, false);
                    continue;
                }
                if ((attributes[i] & 2) == 0) continue;
                doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_UNCHANGED, false);
            }
        }
        for (int i = 0; i < this.diffInfos.size(); ++i) {
            Map<Integer, List<DiffDriver.TextRun>> diffInfo = this.diffInfos.get(i);
            for (Map.Entry<Integer, List<DiffDriver.TextRun>> e : diffInfo.entrySet()) {
                int diffPos = e.getKey();
                if (diffPos == -1) continue;
                for (DiffDriver.TextRun r : e.getValue()) {
                    int tokstart = this.delimiters.get(i) + diffPos + r.start;
                    switch (r.type) {
                        case DELETE: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_DELETED_ACTIVE : ATTRIBUTES_DELETED_INACTIVE, false);
                            break;
                        }
                        case INSERT: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_INSERTED_ACTIVE : ATTRIBUTES_INSERTED_INACTIVE, false);
                            break;
                        }
                    }
                }
            }
        }
        doc.setCharacterAttributes(start, end - start, ATTRIBUTES_SELECTED, false);
        this.setCaretPosition(end - 2);
        final int fstart = start;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MatchesTextArea.this.setCaretPosition(fstart);
            }
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.activeMatch = -1;
        this.matches.clear();
        this.delimiters.clear();
        this.sourcePos.clear();
        this.diffInfos.clear();
    }

    private void populateContextMenu(JPopupMenu popup, final int index) {
        boolean hasMatches;
        boolean bl = hasMatches = Core.getProject().isProjectLoaded() && index >= 0 && index < this.matches.size();
        if (hasMatches) {
            NearString m = this.matches.get(index);
            if (m.projs.length > 1) {
                JMenuItem item = popup.add(OStrings.getString("MATCHES_PROJECTS"));
                item.setEnabled(false);
                for (int i = 0; i < m.projs.length; ++i) {
                    String proj = m.projs[i];
                    StringBuilder b = new StringBuilder();
                    if (proj.equals("")) {
                        b.append(OStrings.getString("MATCHES_THIS_PROJECT"));
                    } else {
                        b.append(proj);
                    }
                    b.append(" ");
                    b.append(m.scores[i].toString());
                    JMenuItem pItem = popup.add(b.toString());
                    pItem.setEnabled(false);
                }
                popup.addSeparator();
            }
        }
        JMenuItem item = popup.add(OStrings.getString("MATCHES_INSERT"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(index);
                }
                Core.getMainWindow().getMainMenu().invokeAction("editInsertTranslationMenuItem", 0);
            }
        });
        item.setEnabled(hasMatches);
        item = popup.add(OStrings.getString("MATCHES_REPLACE"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(index);
                }
                Core.getMainWindow().getMainMenu().invokeAction("editOverwriteTranslationMenuItem", 0);
            }
        });
        item.setEnabled(hasMatches);
        popup.addSeparator();
        item = popup.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
        item.setEnabled(hasMatches);
        if (hasMatches) {
            final NearString ns = this.matches.get(index);
            String proj = ns.projs[0];
            if (StringUtil.isEmpty(proj)) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Core.getEditor().gotoEntry(ns.source, ns.key);
                    }
                });
            } else {
                item.setEnabled(false);
            }
        }
    }

    @Override
    public void setNextActiveMatch() {
        if (this.activeMatch < this.matches.size() - 1) {
            this.setActiveMatch(this.activeMatch + 1);
        }
    }

    @Override
    public void setPrevActiveMatch() {
        if (this.activeMatch > 0) {
            this.setActiveMatch(this.activeMatch - 1);
        }
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        this.populateContextMenu(menu, this.activeMatch);
        menu.addSeparator();
        JCheckBoxMenuItem notify = new JCheckBoxMenuItem(OStrings.getString("GUI_MATCHWINDOW_SETTINGS_NOTIFICATIONS"));
        notify.setSelected(Preferences.isPreference("notify_fuzzy_matches"));
        notify.addActionListener(e -> Preferences.setPreference("notify_fuzzy_matches", notify.isSelected()));
        menu.add(notify);
        menu.addSeparator();
        JMenuItem prefs = new JMenuItem(OStrings.getString("MATCHES_OPEN_PREFERENCES"));
        prefs.addActionListener(e -> new PreferencesWindowController().show(Core.getMainWindow().getApplicationFrame(), TMMatchesPreferencesController.class));
        menu.add(prefs);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        KeyStroke s = KeyStroke.getKeyStrokeForEvent(e);
        if (s.equals(PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorContextMenu"))) {
            JPopupMenu popup = new JPopupMenu();
            this.populateContextMenu(popup, this.activeMatch);
            Caret caret = this.getCaret();
            Point p = caret == null ? this.getMousePosition() : caret.getMagicCaretPosition();
            popup.show(this, (int)p.getX(), (int)p.getY());
            e.consume();
        }
        super.processKeyEvent(e);
    }
}

