/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.Tools;
import org.omegat.core.Core;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.LanguageToolConfigurationPanel;
import org.omegat.languagetools.LanguageToolNativeBridge;
import org.omegat.languagetools.LanguageToolPrefs;
import org.omegat.languagetools.LanguageToolWrapper;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.openide.awt.Mnemonics;
import org.xml.sax.SAXException;

public class LanguageToolConfigurationController
extends BasePreferencesController {
    private static final String NEW_RULE_PATTERN = "^[A-Za-z_.]+$";
    private LanguageToolWrapper.BridgeType selectedBridgeType;
    private Set<String> disabledCategories;
    private Set<String> disabledRuleIds;
    private Set<String> enabledRuleIds;
    private String targetLanguageCode;
    private LanguageToolConfigurationPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_LANGUAGETOOL");
    }

    private void initGui() {
        this.panel = new LanguageToolConfigurationPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.panel.bridgeNativeRadioButton, (String)StringUtil.format(OStrings.getString("GUI_LANGUAGETOOL_NATIVE_BRIDGE"), "3.5"));
        this.panel.bridgeNativeRadioButton.addActionListener(e -> this.handleBridgeTypeChange(LanguageToolWrapper.BridgeType.NATIVE));
        this.panel.bridgeLocalRadioButton.addActionListener(e -> this.handleBridgeTypeChange(LanguageToolWrapper.BridgeType.LOCAL_INSTALLATION));
        this.panel.bridgeRemoteRadioButton.addActionListener(e -> this.handleBridgeTypeChange(LanguageToolWrapper.BridgeType.REMOTE_URL));
        this.panel.directoryChooseButton.addActionListener(e -> this.chooseLocalInstallation());
        this.panel.addRuleButton.addActionListener(e -> this.addRule());
        this.panel.deleteRuleButton.addActionListener(e -> this.deleteRules());
        if (Core.getProject().isProjectLoaded()) {
            this.targetLanguageCode = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
            this.initWithLangs();
        } else {
            this.initWithoutLangs();
        }
    }

    private void initWithoutLangs() {
        this.disableRulesUI(OStrings.getString("GUI_LANGUAGETOOL_RULES_UNAVAILABLE_NO_PROJECT"));
    }

    private void chooseLocalInstallation() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(OStrings.getString("GUI_LANGUAGETOOL_JAR_FILE_FILTER"), "jar");
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle(OStrings.getString("GUI_LANGUAGETOOL_FILE_CHOOSER_TITLE"));
        int result = fileChooser.showOpenDialog(this.panel);
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            this.panel.localServerJarPathTextField.setText(file.getAbsolutePath());
        }
    }

    private void addRule() {
        String newRuleId = (String)JOptionPane.showInputDialog(this.panel, OStrings.getString("GUI_LANGUAGETOOL_ADD_RULE_MESSAGE"), OStrings.getString("GUI_LANGUAGETOOL_ADD_RULE_DIALOG_TITLE"), -1, null, null, null);
        if (newRuleId == null) {
            return;
        }
        if (!Pattern.matches(NEW_RULE_PATTERN, newRuleId)) {
            JOptionPane.showMessageDialog(this.panel, OStrings.getString("GUI_LANGUAGETOOL_BAD_RULE_ID"));
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.panel.rulesTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.panel.rulesTree.getModel().getRoot();
        CategoryNode externalCategoryNode = null;
        CategoryNode lastCategoryNode = (CategoryNode)root.getLastChild();
        if (lastCategoryNode.getCategory().getId().toString().equals("EXTERNAL")) {
            for (int i = 0; i < lastCategoryNode.getChildCount(); ++i) {
                if (!((RuleNode)lastCategoryNode.getChildAt(i)).getRule().getId().equals(newRuleId)) continue;
                JOptionPane.showMessageDialog(this.panel, OStrings.getString("GUI_LANGUAGETOOL_RULE_ALREADY_EXISTS"));
                return;
            }
            externalCategoryNode = lastCategoryNode;
        } else {
            externalCategoryNode = new CategoryNode(ExternalRule.DEFAULT_CATEGORY, true);
            model.insertNodeInto(externalCategoryNode, root, root.getChildCount());
        }
        RuleNode newRuleNode = new RuleNode(new ExternalRule(newRuleId), true);
        model.insertNodeInto(newRuleNode, externalCategoryNode, externalCategoryNode.getChildCount());
        if (!externalCategoryNode.isEnabled()) {
            externalCategoryNode.setEnabled(true);
            model.nodeChanged(externalCategoryNode);
        }
        this.panel.rulesTree.scrollPathToVisible(new TreePath(newRuleNode.getPath()));
    }

    private void deleteRules() {
        TreePath[] currentSelections = this.panel.rulesTree.getSelectionPaths();
        if (currentSelections != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.panel.rulesTree.getModel();
            Stream.of(currentSelections).map(TreePath::getLastPathComponent).filter(LanguageToolConfigurationController::isExternalRuleNode).forEach(node -> {
                MutableTreeNode currentNode = (MutableTreeNode)node;
                MutableTreeNode parent = (MutableTreeNode)currentNode.getParent();
                model.removeNodeFromParent(currentNode);
                if (parent.getChildCount() == 0) {
                    model.removeNodeFromParent(parent);
                }
            });
        }
    }

    private void disableRulesUI(String message) {
        this.panel.rulesMessagePanel.setVisible(true);
        this.panel.rulesMessageLabel.setText(message);
        this.panel.rulesMessageLabel.setEnabled(false);
        this.panel.rulesScrollPane.setVisible(false);
        this.panel.rulesButtonsPanel.setVisible(false);
    }

    private void initWithLangs() {
        this.panel.rulesMessagePanel.setVisible(false);
        this.panel.rulesTree.addTreeSelectionListener(e -> this.updateButtonState());
        this.panel.rulesTree.setCellRenderer(new CheckBoxTreeCellRenderer());
        TreeListener.install(this.panel.rulesTree);
    }

    private void loadRules(Language sourceLang, Language targetLang) {
        JLanguageTool ltInstance;
        org.languagetool.Language targetLtLang = LanguageToolNativeBridge.getLTLanguage(targetLang);
        org.languagetool.Language sourceLtLang = LanguageToolNativeBridge.getLTLanguage(sourceLang);
        if (targetLtLang == null) {
            this.disableRulesUI(OStrings.getString("GUI_LANGUAGETOOL_RULES_UNAVAILABLE"));
            return;
        }
        try {
            ltInstance = new JLanguageTool(targetLtLang);
        }
        catch (Throwable e) {
            this.disableRulesUI(OStrings.getString("GUI_LANGUAGETOOL_RULES_UNAVAILABLE_ERROR"));
            Log.log(e);
            return;
        }
        List rules = ltInstance.getAllRules();
        if (sourceLtLang != null) {
            try {
                rules.addAll(Tools.getBitextRules((org.languagetool.Language)sourceLtLang, (org.languagetool.Language)targetLtLang));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Log.log(e);
            }
        }
        List internalRuleIds = rules.stream().map(Rule::getId).collect(Collectors.toList());
        rules.stream().filter(Rule::isDefaultOff).map(Rule::getId).forEach(this.disabledRuleIds::remove);
        ArrayList<String> externalRuleIds = new ArrayList<String>(this.disabledRuleIds);
        externalRuleIds.addAll(this.enabledRuleIds);
        externalRuleIds.removeAll(internalRuleIds);
        externalRuleIds.stream().distinct().map(ExternalRule::new).forEach(rules::add);
        DefaultMutableTreeNode rootNode = this.createTree(rules);
        this.panel.rulesTree.setModel(this.getTreeModel(rootNode));
        this.panel.rulesTree.applyComponentOrientation(ComponentOrientation.getOrientation(targetLtLang.getLocale()));
        this.updateButtonState();
    }

    private DefaultMutableTreeNode createTree(List<Rule> rules) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Rules");
        String lastRuleId = null;
        TreeMap<String, CategoryNode> parents = new TreeMap<String, CategoryNode>();
        for (Rule rule : rules) {
            if (!parents.containsKey(rule.getCategory().getId().toString())) {
                boolean enabled = true;
                if (this.disabledCategories != null && this.disabledCategories.contains(rule.getCategory().getId().toString())) {
                    enabled = false;
                }
                if (rule.getCategory().isDefaultOff()) {
                    enabled = false;
                }
                CategoryNode categoryNode = new CategoryNode(rule.getCategory(), enabled);
                root.add(categoryNode);
                parents.put(rule.getCategory().getId().toString(), categoryNode);
            }
            if (!rule.getId().equals(lastRuleId)) {
                RuleNode ruleNode = new RuleNode(rule, this.getEnabledState(rule));
                CategoryNode parent = (CategoryNode)parents.get(rule.getCategory().getId().toString());
                parent.add(ruleNode);
                if (ruleNode.isEnabled()) {
                    parent.setEnabled(true);
                }
            }
            lastRuleId = rule.getId();
        }
        return root;
    }

    void updateButtonState() {
        TreePath[] selected = this.panel.rulesTree.getSelectionPaths();
        boolean deletable = selected != null && Stream.of(selected).map(TreePath::getLastPathComponent).allMatch(LanguageToolConfigurationController::isExternalRuleNode);
        this.panel.deleteRuleButton.setEnabled(deletable);
    }

    static boolean isExternalRuleNode(Object node) {
        return node instanceof RuleNode && ((RuleNode)node).getRule() instanceof ExternalRule;
    }

    private boolean getEnabledState(Rule rule) {
        boolean ret = true;
        if (this.disabledRuleIds.contains(rule.getId())) {
            ret = false;
        }
        if (this.disabledCategories.contains(rule.getCategory().getId().toString())) {
            ret = false;
        }
        if ((rule.isDefaultOff() || rule.getCategory().isDefaultOff()) && !this.enabledRuleIds.contains(rule.getId())) {
            ret = false;
        }
        if (rule.isDefaultOff() && rule.getCategory().isDefaultOff() && this.enabledRuleIds.contains(rule.getId())) {
            this.disabledCategories.remove(rule.getCategory().getId().toString());
        }
        return ret;
    }

    private DefaultTreeModel getTreeModel(DefaultMutableTreeNode rootNode) {
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode o;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int index = e.getChildIndices()[0];
                if ((node = (DefaultMutableTreeNode)node.getChildAt(index)) instanceof RuleNode) {
                    o = (RuleNode)node;
                    if (((RuleNode)o).getRule().isDefaultOff() || ((RuleNode)o).getRule().getCategory().isDefaultOff()) {
                        if (((RuleNode)o).isEnabled()) {
                            LanguageToolConfigurationController.this.enabledRuleIds.add(((RuleNode)o).getRule().getId());
                        } else {
                            LanguageToolConfigurationController.this.enabledRuleIds.remove(((RuleNode)o).getRule().getId());
                        }
                    } else {
                        if (((RuleNode)o).isEnabled()) {
                            LanguageToolConfigurationController.this.disabledRuleIds.remove(((RuleNode)o).getRule().getId());
                        } else {
                            LanguageToolConfigurationController.this.disabledRuleIds.add(((RuleNode)o).getRule().getId());
                        }
                        if (((RuleNode)o).getRule().getCategory().getId().toString().equals("EXTERNAL")) {
                            if (((RuleNode)o).isEnabled()) {
                                LanguageToolConfigurationController.this.enabledRuleIds.add(((RuleNode)o).getRule().getId());
                            } else {
                                LanguageToolConfigurationController.this.enabledRuleIds.remove(((RuleNode)o).getRule().getId());
                            }
                        }
                    }
                    if (LanguageToolConfigurationController.this.disabledCategories.contains(((RuleNode)o).getRule().getCategory().getId().toString()) && !((RuleNode)o).getRule().getCategory().getId().toString().equals("EXTERNAL")) {
                        LanguageToolConfigurationController.this.disabledRuleIds.remove(((RuleNode)o).getRule().getId());
                    }
                }
                if (node instanceof CategoryNode) {
                    o = (CategoryNode)node;
                    if (((CategoryNode)o).isEnabled()) {
                        LanguageToolConfigurationController.this.disabledCategories.remove(((CategoryNode)o).getCategory().getId().toString());
                    } else {
                        LanguageToolConfigurationController.this.disabledCategories.add(((CategoryNode)o).getCategory().getId().toString());
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)e.getChildren()[0];
                if (newNode instanceof RuleNode) {
                    LanguageToolConfigurationController.this.enabledRuleIds.add(((RuleNode)newNode).getRule().getId());
                }
                if (newNode instanceof CategoryNode) {
                    // empty if block
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)e.getChildren()[0];
                if (removedNode instanceof RuleNode) {
                    if (((RuleNode)removedNode).isEnabled()) {
                        LanguageToolConfigurationController.this.enabledRuleIds.remove(((RuleNode)removedNode).getRule().getId());
                    } else {
                        LanguageToolConfigurationController.this.disabledRuleIds.remove(((RuleNode)removedNode).getRule().getId());
                    }
                }
                if (removedNode instanceof CategoryNode) {
                    LanguageToolConfigurationController.this.disabledCategories.remove(((CategoryNode)removedNode).getCategory().getId().toString());
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        return treeModel;
    }

    private void handleBridgeTypeChange(LanguageToolWrapper.BridgeType type) {
        this.selectedBridgeType = type;
        switch (type) {
            case NATIVE: {
                this.panel.localServerJarPathTextField.setEnabled(false);
                this.panel.directoryChooseButton.setEnabled(false);
                this.panel.urlTextField.setEnabled(false);
                break;
            }
            case REMOTE_URL: {
                this.panel.localServerJarPathTextField.setEnabled(false);
                this.panel.directoryChooseButton.setEnabled(false);
                this.panel.urlTextField.setEnabled(true);
                break;
            }
            case LOCAL_INSTALLATION: {
                this.panel.localServerJarPathTextField.setEnabled(true);
                this.panel.directoryChooseButton.setEnabled(true);
                this.panel.urlTextField.setEnabled(false);
            }
        }
    }

    @Override
    protected void initFromPrefs() {
        LanguageToolWrapper.BridgeType type = LanguageToolPrefs.getBridgeType();
        switch (type) {
            case NATIVE: {
                this.panel.bridgeNativeRadioButton.setSelected(true);
                break;
            }
            case REMOTE_URL: {
                this.panel.bridgeRemoteRadioButton.setSelected(true);
                break;
            }
            case LOCAL_INSTALLATION: {
                this.panel.bridgeLocalRadioButton.setSelected(true);
            }
        }
        this.panel.urlTextField.setText(LanguageToolPrefs.getRemoteUrl());
        this.panel.localServerJarPathTextField.setText(LanguageToolPrefs.getLocalServerJarPath());
        if (this.targetLanguageCode != null) {
            this.disabledCategories = LanguageToolPrefs.getDisabledCategories(this.targetLanguageCode);
            this.disabledRuleIds = LanguageToolPrefs.getDisabledRules(this.targetLanguageCode);
            this.enabledRuleIds = LanguageToolPrefs.getEnabledRules(this.targetLanguageCode);
            this.loadRules(Core.getProject().getProjectProperties().getSourceLanguage(), Core.getProject().getProjectProperties().getTargetLanguage());
        }
        this.handleBridgeTypeChange(type);
    }

    @Override
    public void restoreDefaults() {
        this.panel.bridgeNativeRadioButton.setSelected(true);
        this.panel.urlTextField.setText("");
        this.panel.localServerJarPathTextField.setText("");
        if (this.targetLanguageCode != null) {
            this.disabledCategories = LanguageToolPrefs.getDefaultDisabledCategories();
            this.disabledRuleIds = LanguageToolPrefs.getDefaultDisabledRules();
            this.enabledRuleIds = Collections.emptySet();
            this.loadRules(Core.getProject().getProjectProperties().getSourceLanguage(), Core.getProject().getProjectProperties().getTargetLanguage());
        }
        this.handleBridgeTypeChange(LanguageToolPrefs.DEFAULT_BRIDGE_TYPE);
    }

    @Override
    public void persist() {
        LanguageToolPrefs.setBridgeType(this.selectedBridgeType);
        LanguageToolPrefs.setRemoteUrl(this.panel.urlTextField.getText());
        LanguageToolPrefs.setLocalServerJarPath(this.panel.localServerJarPathTextField.getText());
        if (this.targetLanguageCode != null) {
            LanguageToolPrefs.setDisabledCategories(this.disabledCategories, this.targetLanguageCode);
            LanguageToolPrefs.setDisabledRules(this.disabledRuleIds, this.targetLanguageCode);
            LanguageToolPrefs.setEnabledRules(this.enabledRuleIds, this.targetLanguageCode);
            LanguageToolWrapper.setBridgeFromCurrentProject();
        }
        SwingUtilities.invokeLater(() -> {
            if (Core.getProject().isProjectLoaded()) {
                Core.getEditor().refreshView(true);
            }
        });
    }

    static class CheckBoxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        private final JCheckBox checkBox = new JCheckBox();
        private Component defaultComponent;

        CheckBoxTreeCellRenderer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.checkBox.setOpaque(false);
            this.renderer.setLeafIcon(null);
            this.renderer.setOpenIcon(null);
            this.renderer.setClosedIcon(null);
            this.add((Component)this.checkBox, "West");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof CategoryNode) {
                if (this.defaultComponent != null) {
                    this.remove(this.defaultComponent);
                }
                this.defaultComponent = component;
                this.add(component, "Center");
                CategoryNode node = (CategoryNode)value;
                this.checkBox.setSelected(node.isEnabled());
                return this;
            }
            if (value instanceof RuleNode) {
                if (this.defaultComponent != null) {
                    this.remove(this.defaultComponent);
                }
                this.defaultComponent = component;
                this.add(component, "Center");
                RuleNode node = (RuleNode)value;
                this.checkBox.setSelected(node.isEnabled());
                return this;
            }
            return component;
        }
    }

    static class CategoryNode
    extends DefaultMutableTreeNode {
        private final Category category;
        private boolean enabled;

        CategoryNode(Category category, boolean enabled) {
            super(category);
            this.category = category;
            this.enabled = enabled;
        }

        Category getCategory() {
            return this.category;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public String toString() {
            int children = this.getChildCount();
            int selected = 0;
            for (int i = 0; i < children; ++i) {
                RuleNode child = (RuleNode)this.getChildAt(i);
                if (!child.isEnabled()) continue;
                ++selected;
            }
            return String.format("%s (%d/%d)", this.category.getName(), selected, children);
        }
    }

    static class RuleNode
    extends DefaultMutableTreeNode {
        private final Rule rule;
        private boolean enabled;

        RuleNode(Rule rule, boolean enabled) {
            super(rule);
            this.rule = rule;
            this.enabled = enabled;
        }

        Rule getRule() {
            return this.rule;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public String toString() {
            return this.rule.getDescription();
        }
    }

    static class TreeListener
    implements KeyListener,
    MouseListener {
        private static final Dimension CHECKBOX_DIMENSION = new JCheckBox().getPreferredSize();
        private final JTree tree;

        static void install(JTree tree) {
            TreeListener listener = new TreeListener(tree);
            tree.addMouseListener(listener);
            tree.addKeyListener(listener);
        }

        TreeListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath[] paths;
            if (e.getKeyCode() == 32 && (paths = this.tree.getSelectionPaths()) != null) {
                for (TreePath path : paths) {
                    this.handle(path);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null && path.getPathCount() > 0 && this.isValidNode(path.getLastPathComponent()) && this.isOverCheckBox(e.getX(), e.getY(), path)) {
                this.handle(path);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void handle(TreePath path) {
            if (path != null && path.getPathCount() > 0) {
                DefaultMutableTreeNode node;
                DefaultTreeModel model;
                if (path.getLastPathComponent() instanceof CategoryNode) {
                    model = (DefaultTreeModel)this.tree.getModel();
                    ((CategoryNode)node).setEnabled(!((CategoryNode)(node = (CategoryNode)path.getLastPathComponent())).isEnabled());
                    model.nodeChanged(node);
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        RuleNode child = (RuleNode)node.getChildAt(i);
                        if (child.isEnabled() == ((CategoryNode)node).isEnabled()) continue;
                        child.setEnabled(((CategoryNode)node).isEnabled());
                        model.nodeChanged(child);
                    }
                }
                if (path.getLastPathComponent() instanceof RuleNode) {
                    model = (DefaultTreeModel)this.tree.getModel();
                    ((RuleNode)node).setEnabled(!((RuleNode)(node = (RuleNode)path.getLastPathComponent())).isEnabled());
                    model.nodeChanged(node);
                    if (((RuleNode)node).isEnabled()) {
                        CategoryNode parent = (CategoryNode)node.getParent();
                        parent.setEnabled(true);
                    }
                    model.nodeChanged(node.getParent());
                }
            }
        }

        private boolean isOverCheckBox(int x, int y, TreePath path) {
            int offset = this.tree.getPathBounds((TreePath)path).x + TreeListener.CHECKBOX_DIMENSION.width;
            return x <= offset;
        }

        private boolean isValidNode(Object c) {
            return c instanceof CategoryNode || c instanceof RuleNode;
        }
    }

    static class ExternalRule
    extends Rule {
        public static final String CATEGORY_ID = "EXTERNAL";
        public static final Category DEFAULT_CATEGORY = new Category(new CategoryId("EXTERNAL"), OStrings.getString("GUI_LANGUAGETOOL_EXTERNAL_CATEGORY_NAME"));
        private final String id;

        ExternalRule(String id) {
            this.id = id;
            this.setCategory(DEFAULT_CATEGORY);
            this.setDefaultOn();
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.id;
        }

        public RuleMatch[] match(AnalyzedSentence as) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

