/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class RoundedCornerBorder
extends AbstractBorder {
    public static final int SIDE_TOP = 0;
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_BOTTOM = 2;
    public static final int SIDE_RIGHT = 3;
    public static final int SIDE_ALL = 4;
    private final int radius;
    private final Color color;
    private final int side;
    private final int stroke;
    private final transient Stroke strokeObj;

    public RoundedCornerBorder() {
        this(-1, Color.GRAY, 4);
    }

    public RoundedCornerBorder(int radius, Color color, int side) {
        this(radius, color, side, 1);
    }

    public RoundedCornerBorder(int radius, Color color, int side, int stroke) {
        this.radius = radius;
        this.color = color;
        this.side = side;
        this.stroke = stroke;
        this.strokeObj = new BasicStroke(stroke);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Line2D.Float line2;
        Line2D.Float line1;
        Rectangle2D.Float roundedHalfClip;
        Color background;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(this.strokeObj);
        int r = this.radius == -1 ? height - this.stroke : this.radius;
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(x, y, (float)width - ((float)this.stroke - 0.5f), height - this.stroke, r, r);
        Rectangle2D.Float sharpRect = new Rectangle2D.Float(x, y, width, height);
        Area corners = new Area(sharpRect);
        corners.subtract(new Area(roundRect));
        Color color = background = c.getParent() == null ? null : c.getParent().getBackground();
        if (this.side == 4) {
            this.drawCorners(g2, background, corners, roundRect);
            g2.dispose();
            return;
        }
        Shape initialClip = g2.getClip();
        if (this.side == 0) {
            roundedHalfClip = new Rectangle2D.Float(x, y, width, height / 2);
            line1 = new Line2D.Float(x, y, x, y + height);
            line2 = new Line2D.Float((float)(x + width) - 0.5f, y, (float)(x + width) - 0.5f, y + height);
        } else if (this.side == 1) {
            roundedHalfClip = new Rectangle2D.Float(x, y, width / 2 + this.stroke, height);
            line1 = new Line2D.Float(x, y, x + width, y);
            line2 = new Line2D.Float(x, y + height - this.stroke, x + width, y + height - this.stroke);
        } else if (this.side == 2) {
            roundedHalfClip = new Rectangle2D.Float(x, y + height / 2, width, height / 2 + this.stroke);
            line1 = new Line2D.Float(x, y, x, y + height);
            line2 = new Line2D.Float((float)(x + width) - ((float)this.stroke - 0.5f), y, (float)(x + width) - ((float)this.stroke - 0.5f), y + height);
        } else if (this.side == 3) {
            roundedHalfClip = new Rectangle2D.Float(x + width / 2, y, width / 2 + this.stroke, height);
            line1 = new Line2D.Float(x, y, x + width, y);
            line2 = new Line2D.Float(x, y + height - this.stroke, x + width, y + height - this.stroke);
        } else {
            throw new IllegalArgumentException();
        }
        g2.clip(roundedHalfClip);
        this.drawCorners(g2, background, corners, roundRect);
        Area inverseClip = new Area(sharpRect);
        inverseClip.subtract(new Area(roundedHalfClip));
        g2.setClip(initialClip);
        g2.clip(inverseClip);
        g2.draw(line1);
        g2.draw(line2);
        g2.dispose();
    }

    private void drawCorners(Graphics2D g2, Color background, Area corners, Shape shape) {
        if (background != null) {
            g2.setColor(background);
            g2.fill(corners);
        }
        g2.setColor(this.color);
        g2.draw(shape);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(4, 8, 4, 8);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(4, 8, 4, 8);
        return insets;
    }
}

