/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DictionaryUtil {
    public static int readVInt(ByteBuffer bb) {
        byte b = bb.get();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = bb.get();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = bb.get();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = bb.get();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = bb.get();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public static void writeVInt(DataOutput d, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            d.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        d.writeByte((byte)i);
    }

    public static void writeKatakana(DataOutput d, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            d.writeByte(s.charAt(i) - 12448);
        }
    }

    public static void readString(ByteBuffer b, char[] s, int off, int len) {
        while (off < len) {
            s[off++] = b.getChar();
        }
    }

    public static void readKatakana(ByteBuffer b, char[] s, int off, int len) {
        while (off < len) {
            s[off++] = (char)(12448 + (b.get() & 0xFF));
        }
    }
}

