/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.bv.BitVector;

public class BytesSelect0OnlySuccinctBitVector
implements Externalizable,
BitVector {
    private static final int CACHE_WIDTH = 64;
    private byte[] vector;
    private int node1pos = -1;
    private int node2pos = -1;
    private int node3pos = -1;
    private int size;
    private int size0;
    private int[] countCache0;
    private int[] indexCache0;
    private static final byte[] BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] BITCOUNTS0 = new byte[]{8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 2, 1, 1, 0};
    private static final byte[][] BITPOS0 = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 3}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 7}, {0, 1, 2, 4}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 7}, {0, 1, 2, 5}, {0, 1, 2, 6, 7}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 7}, {0, 1, 3, 4}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 7}, {0, 1, 3, 5}, {0, 1, 3, 6, 7}, {0, 1, 3, 6}, {0, 1, 3, 7}, {0, 1, 3}, {0, 1, 4, 5, 6, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 7}, {0, 1, 4, 5}, {0, 1, 4, 6, 7}, {0, 1, 4, 6}, {0, 1, 4, 7}, {0, 1, 4}, {0, 1, 5, 6, 7}, {0, 1, 5, 6}, {0, 1, 5, 7}, {0, 1, 5}, {0, 1, 6, 7}, {0, 1, 6}, {0, 1, 7}, {0, 1}, {0, 2, 3, 4, 5, 6, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 2, 3, 4}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 7}, {0, 2, 3, 5}, {0, 2, 3, 6, 7}, {0, 2, 3, 6}, {0, 2, 3, 7}, {0, 2, 3}, {0, 2, 4, 5, 6, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 7}, {0, 2, 4, 5}, {0, 2, 4, 6, 7}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 4}, {0, 2, 5, 6, 7}, {0, 2, 5, 6}, {0, 2, 5, 7}, {0, 2, 5}, {0, 2, 6, 7}, {0, 2, 6}, {0, 2, 7}, {0, 2}, {0, 3, 4, 5, 6, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 7}, {0, 3, 4, 5}, {0, 3, 4, 6, 7}, {0, 3, 4, 6}, {0, 3, 4, 7}, {0, 3, 4}, {0, 3, 5, 6, 7}, {0, 3, 5, 6}, {0, 3, 5, 7}, {0, 3, 5}, {0, 3, 6, 7}, {0, 3, 6}, {0, 3, 7}, {0, 3}, {0, 4, 5, 6, 7}, {0, 4, 5, 6}, {0, 4, 5, 7}, {0, 4, 5}, {0, 4, 6, 7}, {0, 4, 6}, {0, 4, 7}, {0, 4}, {0, 5, 6, 7}, {0, 5, 6}, {0, 5, 7}, {0, 5}, {0, 6, 7}, {0, 6}, {0, 7}, {0}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 7}, {1, 2, 3, 4}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 7}, {1, 2, 3, 5}, {1, 2, 3, 6, 7}, {1, 2, 3, 6}, {1, 2, 3, 7}, {1, 2, 3}, {1, 2, 4, 5, 6, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 7}, {1, 2, 4, 5}, {1, 2, 4, 6, 7}, {1, 2, 4, 6}, {1, 2, 4, 7}, {1, 2, 4}, {1, 2, 5, 6, 7}, {1, 2, 5, 6}, {1, 2, 5, 7}, {1, 2, 5}, {1, 2, 6, 7}, {1, 2, 6}, {1, 2, 7}, {1, 2}, {1, 3, 4, 5, 6, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 7}, {1, 3, 4, 5}, {1, 3, 4, 6, 7}, {1, 3, 4, 6}, {1, 3, 4, 7}, {1, 3, 4}, {1, 3, 5, 6, 7}, {1, 3, 5, 6}, {1, 3, 5, 7}, {1, 3, 5}, {1, 3, 6, 7}, {1, 3, 6}, {1, 3, 7}, {1, 3}, {1, 4, 5, 6, 7}, {1, 4, 5, 6}, {1, 4, 5, 7}, {1, 4, 5}, {1, 4, 6, 7}, {1, 4, 6}, {1, 4, 7}, {1, 4}, {1, 5, 6, 7}, {1, 5, 6}, {1, 5, 7}, {1, 5}, {1, 6, 7}, {1, 6}, {1, 7}, {1}, {2, 3, 4, 5, 6, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 7}, {2, 3, 4, 5}, {2, 3, 4, 6, 7}, {2, 3, 4, 6}, {2, 3, 4, 7}, {2, 3, 4}, {2, 3, 5, 6, 7}, {2, 3, 5, 6}, {2, 3, 5, 7}, {2, 3, 5}, {2, 3, 6, 7}, {2, 3, 6}, {2, 3, 7}, {2, 3}, {2, 4, 5, 6, 7}, {2, 4, 5, 6}, {2, 4, 5, 7}, {2, 4, 5}, {2, 4, 6, 7}, {2, 4, 6}, {2, 4, 7}, {2, 4}, {2, 5, 6, 7}, {2, 5, 6}, {2, 5, 7}, {2, 5}, {2, 6, 7}, {2, 6}, {2, 7}, {2}, {3, 4, 5, 6, 7}, {3, 4, 5, 6}, {3, 4, 5, 7}, {3, 4, 5}, {3, 4, 6, 7}, {3, 4, 6}, {3, 4, 7}, {3, 4}, {3, 5, 6, 7}, {3, 5, 6}, {3, 5, 7}, {3, 5}, {3, 6, 7}, {3, 6}, {3, 7}, {3}, {4, 5, 6, 7}, {4, 5, 6}, {4, 5, 7}, {4, 5}, {4, 6, 7}, {4, 6}, {4, 7}, {4}, {5, 6, 7}, {5, 6}, {5, 7}, {5}, {6, 7}, {6}, {7}, new byte[0]};
    private static final long serialVersionUID = -7658605229245494623L;

    public BytesSelect0OnlySuccinctBitVector() {
        this(16);
    }

    public BytesSelect0OnlySuccinctBitVector(int initialCapacity) {
        this.vector = new byte[initialCapacity / 8 + 1];
        int blockSize = 64;
        int size = initialCapacity / blockSize + 1;
        this.countCache0 = new int[size];
        this.indexCache0 = new int[size + 1];
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            b.append((this.vector[i / 8] & 128 >> i % 8) != 0 ? "1" : "0");
        }
        return b.toString();
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.vector[pos / 8] & BITS[pos % 8]) == 0;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.vector[pos / 8] & BITS[pos % 8]) != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void trimToSize() {
        int size;
        int vectorSize = this.size / 8 + 1;
        this.vector = Arrays.copyOf(this.vector, Math.min(this.vector.length, vectorSize));
        int blockSize = 8;
        int countCacheSize0 = size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, Math.min(this.countCache0.length, countCacheSize0));
        int indexCacheSize = size + 1;
        this.indexCache0 = Arrays.copyOf(this.indexCache0, Math.min(this.indexCache0.length, indexCacheSize));
    }

    @Override
    public void append1() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.vector.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int r = this.size % 8;
        int n = i;
        this.vector[n] = (byte)(this.vector[n] | BITS[r]);
        ++this.size;
    }

    @Override
    public void append0() {
        int i = this.size / 8;
        int ci = this.size / 64;
        if (i >= this.vector.length) {
            this.extend();
        }
        if (this.size % 64 == 0 && ci > 0) {
            this.countCache0[ci] = this.countCache0[ci - 1];
        }
        int r = this.size % 8;
        int n = i;
        this.vector[n] = (byte)(this.vector[n] & ~BITS[r]);
        ++this.size0;
        switch (this.size0) {
            case 1: {
                this.node1pos = this.size;
                break;
            }
            case 2: {
                this.node2pos = this.size;
                break;
            }
            case 3: {
                this.node3pos = this.size;
            }
        }
        if (this.size0 % 64 == 0) {
            this.indexCache0[this.size0 / 64] = this.size;
        }
        int n2 = ci;
        this.countCache0[n2] = this.countCache0[n2] + 1;
        ++this.size;
    }

    public int select0(int count) {
        int c;
        if (count > this.size) {
            return -1;
        }
        if (count <= 3) {
            if (count == 1) {
                return this.node1pos;
            }
            if (count == 2) {
                return this.node2pos;
            }
            if (count == 3) {
                return this.node3pos;
            }
            return -1;
        }
        int idx = count / 64;
        int start = this.indexCache0[idx];
        if (count % 64 == 0) {
            return start;
        }
        start /= 64;
        int end = 0;
        if (this.indexCache0.length > idx + 1 && (c = this.indexCache0[idx + 1] / 64 + 1) != 1) {
            end = c;
        }
        if (end == 0) {
            int vectorSize = this.size / 8 + 1;
            int blockSize = 8;
            end = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        }
        int m = 0;
        int d = 0;
        while (start != end) {
            m = (start + end) / 2;
            d = count - this.countCache0[m];
            if (d < 0) {
                end = m;
                continue;
            }
            if (d <= 0 || start == m) break;
            start = m;
        }
        if (d > 0) {
            count = d;
        } else {
            while (m >= 0 && count <= this.countCache0[m]) {
                --m;
            }
            if (m >= 0) {
                count -= this.countCache0[m];
            }
        }
        int n = this.size / 8 + 1;
        for (int i = (m + 1) * 64 / 8; i < n; ++i) {
            int bits = this.vector[i] & 0xFF;
            byte c2 = BITCOUNTS0[bits];
            if (count <= c2) {
                return i * 8 + BITPOS0[bits][count - 1];
            }
            count -= c2;
        }
        return -1;
    }

    public int next0(int pos) {
        if (pos >= this.size) {
            return -1;
        }
        if (pos <= this.node3pos) {
            if (pos <= this.node1pos) {
                return this.node1pos;
            }
            if (pos <= this.node2pos) {
                return this.node2pos;
            }
            return this.node3pos;
        }
        int i = pos / 8;
        int s = pos % 8;
        if (s != 0) {
            for (byte b : BITPOS0[this.vector[i] & 0xFF]) {
                if (s > b) continue;
                return i * 8 + b;
            }
            ++i;
        }
        int n = this.size / 8 + 1;
        while (i < n) {
            byte[] poss = BITPOS0[this.vector[i] & 0xFF];
            if (poss.length > 0) {
                return poss[0] + i * 8;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int i;
        this.size = in.readInt();
        this.size0 = in.readInt();
        this.node1pos = in.readInt();
        this.node2pos = in.readInt();
        this.node3pos = in.readInt();
        int vectorSize = in.readInt();
        this.vector = new byte[vectorSize];
        in.readFully(this.vector, 0, vectorSize);
        int size = in.readInt();
        this.countCache0 = new int[size];
        for (i = 0; i < size; ++i) {
            this.countCache0[i] = in.readInt();
        }
        size = in.readInt();
        this.indexCache0 = new int[size];
        for (i = 0; i < size; ++i) {
            this.indexCache0[i] = in.readInt();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.size0);
        out.writeInt(this.node1pos);
        out.writeInt(this.node2pos);
        out.writeInt(this.node3pos);
        this.trimToSize();
        out.writeInt(this.vector.length);
        out.write(this.vector);
        out.writeInt(this.countCache0.length);
        for (int e : this.countCache0) {
            out.writeInt(e);
        }
        out.writeInt(this.indexCache0.length);
        for (int e : this.indexCache0) {
            out.writeInt(e);
        }
    }

    private void extend() {
        int vectorSize = (int)((double)this.vector.length * 1.2) + 1;
        this.vector = Arrays.copyOf(this.vector, vectorSize);
        int blockSize = 8;
        int size = vectorSize / blockSize + (vectorSize % blockSize != 0 ? 1 : 0);
        this.countCache0 = Arrays.copyOf(this.countCache0, size);
        this.indexCache0 = Arrays.copyOf(this.indexCache0, size + 1);
    }
}

