/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.finder;

import org.dts.spell.finder.Word;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.finder.WordNotFoundException;

public abstract class AbstractWordFinder
implements WordFinder {
    private Word currentWord = null;
    private Word nextWord = null;

    protected abstract Word next(Word var1);

    @Override
    public Word next() {
        if (this.nextWord == null) {
            throw new WordNotFoundException();
        }
        this.currentWord = this.nextWord;
        this.nextWord = this.next(this.currentWord);
        return this.currentWord;
    }

    @Override
    public Word current() {
        if (null == this.currentWord) {
            throw new WordNotFoundException();
        }
        return this.currentWord;
    }

    public boolean hasCurrent() {
        return null != this.currentWord;
    }

    @Override
    public boolean hasNext() {
        return this.nextWord != null;
    }

    protected abstract void replace(String var1, Word var2);

    @Override
    public void replace(String newWord) {
        if (this.currentWord == null) {
            throw new WordNotFoundException();
        }
        boolean isStart = this.currentWord.isStartOfSentence();
        if (isStart) {
            newWord = Word.getStartSentenceWordCase(newWord);
        }
        this.replace(newWord, this.currentWord);
        this.currentWord = new Word(newWord, this.currentWord.getStart(), isStart);
        this.nextWord = this.next(this.currentWord);
    }

    public void init() {
        this.init(null);
    }

    public void init(Word initWord) {
        this.currentWord = initWord;
        this.nextWord = initWord;
        if (null == initWord) {
            this.nextWord = this.next(initWord);
        }
    }
}

