/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import io.github.eb4j.stardict.StarDictDictionary;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Language;
import org.omegat.util.Preferences;

public class StarDict
implements IDictionaryFactory {
    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(new StarDictApplicationEventListener());
    }

    public static void unloadPlugins() {
    }

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".ifo");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File file, Language language) throws Exception {
        return new StarDictDict(file, language);
    }

    static class StarDictDict
    implements IDictionary {
        protected final StarDictDictionary dictionary;
        protected final Language language;
        private static final String CONDENSED_SPAN = "<span class=\"paragraph-start\">&nbsp;\u00b6</span><span>";

        StarDictDict(File file, Language language) throws Exception {
            this.dictionary = StarDictDictionary.loadDictionary((File)file, (int)1000, (Duration)Duration.ofMinutes(30L));
            this.language = language;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            List result = this.dictionary.readArticles(word);
            if (result.isEmpty()) {
                result = this.dictionary.readArticles(word.toLowerCase(this.language.getLocale()));
            }
            return result.stream().filter(StarDictDict::useEntry).map(StarDictDict::convertEntry).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            List result = this.dictionary.readArticlesPredictive(word);
            if (result.isEmpty()) {
                result = this.dictionary.readArticlesPredictive(word.toLowerCase(this.language.getLocale()));
            }
            return result.stream().filter(StarDictDict::useEntry).map(StarDictDict::convertEntry).collect(Collectors.toList());
        }

        private static boolean useEntry(StarDictDictionary.Entry entry) {
            StarDictDictionary.EntryType type = entry.getType();
            return type == StarDictDictionary.EntryType.MEAN || type == StarDictDictionary.EntryType.PHONETIC || type == StarDictDictionary.EntryType.HTML || type == StarDictDictionary.EntryType.XDXF;
        }

        private static DictionaryEntry convertEntry(StarDictDictionary.Entry entry) {
            boolean condensed = Preferences.isPreferenceDefault("dictionary_condensed_view", false);
            StringBuilder sb = new StringBuilder();
            if (entry.getType().equals((Object)StarDictDictionary.EntryType.MEAN)) {
                String[] lines = entry.getArticle().split("\n");
                if (condensed) {
                    for (int i = 0; i < lines.length; ++i) {
                        if (i > 0) {
                            sb.append(CONDENSED_SPAN);
                        } else {
                            sb.append("<span>");
                        }
                        sb.append(lines[i]).append("</span>");
                    }
                } else {
                    for (String line : lines) {
                        sb.append("<div>").append(line).append("</div>");
                    }
                }
            } else if (entry.getType().equals((Object)StarDictDictionary.EntryType.PHONETIC)) {
                sb.append("<span>(").append(entry.getArticle()).append(")</span>");
            } else if (entry.getType().equals((Object)StarDictDictionary.EntryType.HTML)) {
                sb.append(entry.getArticle());
            } else if (entry.getType().equals((Object)StarDictDictionary.EntryType.XDXF)) {
                Cleaner cleaner;
                Document document = Jsoup.parse((String)entry.getArticle());
                document.select("k").remove();
                Elements c = document.select("c");
                for (Element e2 : c) {
                    String color = e2.attr("c");
                    e2.tagName("span");
                    e2.removeAttr("c");
                    e2.attr("style", "color: " + color + ";");
                }
                Elements su = document.select("su");
                su.tagName("div");
                su.attr("class", "details");
                Elements ex = document.select("ex");
                ex.tagName("span");
                ex.attr("style", "color: blue;");
                Elements co = document.select("co");
                co.tagName("span");
                co.attr("style", "color: gray;");
                Safelist safelist = new Safelist().addTags(new String[]{"sup", "sub", "i", "b", "tt", "big", "small", "span"});
                safelist.addAttributes("span", new String[]{"style"});
                Elements kref = document.select("kref");
                kref.tagName("span");
                kref.attr("style", "font-style: italic;");
                kref.removeAttr("idref");
                Elements iref = document.select("iref");
                iref.tagName("a");
                Elements rref = document.select("rref");
                for (Element e3 : rref) {
                    String type = e3.attr("type");
                    if (type.isEmpty()) {
                        e3.remove();
                        continue;
                    }
                    String resource = e3.attr("lctn");
                    e3.removeAttr("lctn");
                    if (type.startsWith("audio")) {
                        e3.tagName("a");
                        e3.removeAttr("start");
                        e3.removeAttr("size");
                        e3.attr("href", resource);
                        e3.text("Play");
                        continue;
                    }
                    if (type.startsWith("image")) {
                        e3.tagName("img");
                        e3.attr("src", resource);
                        continue;
                    }
                    if (type.startsWith("video")) {
                        e3.tagName("video");
                        e3.appendChild((Node)new Element("source").attr("src", resource).attr("type", type));
                        e3.removeAttr("type");
                        continue;
                    }
                    e3.remove();
                }
                if (!condensed) {
                    safelist.addTags(new String[]{"blockquote"});
                    cleaner = new Cleaner(safelist);
                    document = cleaner.clean(document);
                    Elements q = document.select("blockquote");
                    q.attr("style", "display: block;margin-left: 20px;");
                    Elements definitionElements = document.select("def");
                    if (definitionElements.size() > 0) {
                        definitionElements.forEach(e -> sb.append("<div>").append(e.html()).append("</div>"));
                    } else {
                        sb.append("<div>").append(document.body().html()).append("</div>");
                    }
                } else {
                    document.select("k").remove();
                    document.select("su").remove();
                    cleaner = new Cleaner(safelist);
                    document = cleaner.clean(document);
                    Elements definitionElements = document.select("def");
                    if (definitionElements.size() > 0) {
                        for (int i = 0; i < definitionElements.size(); ++i) {
                            if (i > 0) {
                                sb.append(CONDENSED_SPAN);
                            } else {
                                sb.append("<span>");
                            }
                            sb.append(((Element)definitionElements.get(i)).html()).append("</span>");
                        }
                    } else {
                        sb.append("<span>").append(document.body().html()).append("</span>");
                    }
                }
            }
            return new DictionaryEntry(entry.getWord(), sb.toString());
        }
    }

    static class StarDictApplicationEventListener
    implements IApplicationEventListener {
        StarDictApplicationEventListener() {
        }

        @Override
        public void onApplicationStartup() {
            Core.getDictionaries().addDictionaryFactory(new StarDict());
        }

        @Override
        public void onApplicationShutdown() {
        }
    }
}

