/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.omegat.externalfinder.item.ExternalFinderItem;

public class ExternalFinderConfiguration {
    private static final int DEFAULT_POPUP_PRIORITY = 50;
    private final int priority;
    private final List<ExternalFinderItem> items;

    public static ExternalFinderConfiguration empty() {
        return new ExternalFinderConfiguration(50, Collections.emptyList());
    }

    public ExternalFinderConfiguration(int priority, List<ExternalFinderItem> items) {
        this.priority = priority >= 0 ? priority : 50;
        this.items = new ArrayList<ExternalFinderItem>(items);
    }

    public int getPriority() {
        return this.priority;
    }

    public List<ExternalFinderItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalFinderConfiguration other = (ExternalFinderConfiguration)obj;
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return this.priority == other.priority;
    }
}

