/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.omegat.util.WikiGet;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.http.FormatFactory;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

public abstract class HttpCyclotis<T>
extends Cyclotis<T> {
    private static final Pattern PATTERN_KEY_VAL = Pattern.compile("^(?:\\;\\s+)?([\\w\\-]+):\\s+(.+)\\r?$");
    public static final int COL_SRC = 0;
    public static final int COL_TRA = 1;
    protected String urlFind;
    protected String urlSave;
    private Map<String, String> headers = null;
    private String dateFormatSpec = null;
    public DateFormat PSQL_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSS", Locale.ENGLISH);

    public HttpCyclotis(Properties propList) {
        super(propList);
        if (propList.getProperty("dateFormat") != null) {
            this.dateFormatSpec = propList.getProperty("dateFormat");
        }
        for (String propName : propList.stringPropertyNames()) {
            if (propName.startsWith("header.")) {
                if (this.headers == null) {
                    this.headers = new HashMap<String, String>();
                }
                this.headers.put(propName.substring(7), propList.getProperty(propName));
                continue;
            }
            if (propName.equals("http.auth.user")) {
                try {
                    String code;
                    if (this.headers == null) {
                        this.headers = new HashMap<String, String>();
                    }
                    if ((code = propList.getProperty("http.auth.user") + ":" + propList.getProperty("http.auth.password")).toLowerCase().contains("#ask")) {
                        JPanel panel = new JPanel();
                        panel.add(new JLabel("User:"));
                        JTextField userField = new JTextField(code.toLowerCase().startsWith("#ask") ? "" : code.substring(0, code.indexOf(":")), 20);
                        panel.add(userField);
                        JPasswordField pass = new JPasswordField(20);
                        panel.add(new JLabel("Password:"));
                        panel.add(pass);
                        int option = JOptionPane.showOptionDialog(null, panel, "Credentials for " + this.getMemoryName(), 1, -1, null, new String[]{"OK", "Cancel"}, "OK");
                        if (option == 0) {
                            code = userField.getText() + ":" + new String(pass.getPassword());
                        }
                    }
                    this.headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString(code.getBytes("UTF-8")));
                    this.logMessage("credentials", "Login as " + code + " aka " + this.headers.get("Authorization"));
                }
                catch (Exception e) {
                    this.logException(e);
                }
                continue;
            }
            if (!propName.startsWith("http.proxy")) continue;
            System.setProperty(propName, propList.getProperty(propName));
        }
        try {
            String url = propList.getProperty("url");
            this.logMessage("http", "Parsing Contents from " + url);
            String tempHeaderFmt = this.headers.get("Accept");
            this.headers.put("Accept", "text/plain");
            String response = WikiGet.get((String)url, null, this.headers);
            if (tempHeaderFmt == null) {
                this.headers.remove("Accept");
            } else {
                this.headers.put("Accept", tempHeaderFmt);
            }
            url = url.substring(0, url.indexOf("/", url.indexOf("//") + 2));
            StringTokenizer tokLines = new StringTokenizer(response, "\n");
            while (tokLines.hasMoreTokens()) {
                String line = tokLines.nextToken();
                this.logMessage("http-response", "HTTP: " + line);
                Matcher match = PATTERN_KEY_VAL.matcher(line);
                if (!match.find()) continue;
                if (match.group(1).contains("url") && match.group(2).startsWith("/")) {
                    propList.setProperty(match.group(1), url + match.group(2));
                } else {
                    propList.setProperty(match.group(1), match.group(2));
                }
                this.logMessage("config-details", "Read property '" + match.group(1) + "' as '" + match.group(2) + "'");
            }
            this.logMessage("", "Parsing of " + this.name + " as " + url + " OK.");
        }
        catch (Exception e) {
            this.logException(e);
        }
        String defaultFormat = propList.getProperty("default-format");
        if (defaultFormat == null) {
            defaultFormat = "line";
        }
        if (propList.getProperty("http.default-format") != null) {
            defaultFormat = propList.getProperty("http.default-format");
        }
        try {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put("Accept", new FormatFactory().createFormat(defaultFormat).MIME());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logException(ex);
        }
        this.urlFind = propList.getProperty("url.find");
        this.urlSave = propList.getProperty("url.save");
        if (this.urlFind == null) {
            this.urlFind = propList.getProperty("find-url");
        }
        if (this.urlFind == null) {
            this.urlFind = propList.getProperty("url").replace("/meta", "/tu").replace("info", ":cmd");
        }
        this.urlFind = this.urlFind.replace(":fmt", defaultFormat).replace("(", "").replace(")?", "");
        if (this.urlSave == null) {
            this.urlSave = propList.getProperty("save-url");
        }
        if (this.urlSave == null) {
            this.urlSave = propList.getProperty("url").replace("/meta", "/tu").replace("/info", "");
        }
        this.urlSave = this.urlSave.replace(":fmt", defaultFormat).replace("(", "").replace(")?", "");
        this.logMessage("config", "URL for find : " + this.urlFind);
        this.logMessage("config", "URL for save : " + this.urlSave);
    }

    public abstract T analyzeLine(HttpOutputFormat var1, Object var2);

    protected final List<T> httpGetAll(String command, String lineFormat, String query) throws Exception {
        String completeUrl = this.urlFind.replace(":cmd", command) + (this.urlFind.contains("?") ? (char)'&' : '?') + "cols=$" + lineFormat + "&query=" + URLEncoder.encode(query, "UTF-8");
        this.logMessage("http", "GET " + completeUrl);
        HttpURLConnection conn = (HttpURLConnection)new URL(completeUrl).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (this.headers != null) {
                for (Map.Entry<String, String> en : this.headers.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                throw new WikiGet.ResponseError(conn);
            }
            String contentType = conn.getHeaderField("Content-Type");
            int cp = contentType != null ? contentType.indexOf("charset=") : -1;
            String charset = cp >= 0 ? contentType.substring(cp + 8) : "ISO8859-1";
            this.logMessage("http", "Response = " + conn.getResponseCode() + " ; content-type = " + contentType + " ; charset = " + charset);
            InputStream in = conn.getInputStream();
            if (this.dateFormatSpec != null) {
                contentType = contentType + ";dateFormat=" + this.dateFormatSpec + ";";
            }
            HttpOutputFormat fmt = new FormatFactory().createFormat(contentType);
            List theList = fmt.readFromGet(this, in, charset);
            this.logMessage("search", "returned " + theList.size() + " entries");
            List list = theList;
            return list;
        }
        catch (Exception ex) {
            this.logException(ex);
            throw ex;
        }
        finally {
            conn.disconnect();
        }
    }

    protected final Iterable<T> httpGetIterable(String command, String lineFormat, String query) throws Exception {
        String completeUrl = this.urlFind.replace(":cmd", command) + (this.urlFind.contains("?") ? (char)'&' : '?') + "cols=$" + lineFormat + "&query=" + URLEncoder.encode(query, "UTF-8");
        this.logMessage("http", "GET " + completeUrl);
        HttpURLConnection conn = (HttpURLConnection)new URL(completeUrl).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (this.headers != null) {
                for (Map.Entry<String, String> en : this.headers.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                throw new WikiGet.ResponseError(conn);
            }
            String contentType = conn.getHeaderField("Content-Type");
            int cp = contentType != null ? contentType.indexOf("charset=") : -1;
            String charset = cp >= 0 ? contentType.substring(cp + 8) : "ISO8859-1";
            this.logMessage("http", "Response = " + conn.getResponseCode() + " ; content-type = " + contentType + " ; charset = " + charset);
            InputStream in = conn.getInputStream();
            if (this.dateFormatSpec != null) {
                contentType = contentType + ";dateFormat=" + this.dateFormatSpec + ";";
            }
            HttpOutputFormat fmt = new FormatFactory().createFormat(contentType);
            return () -> fmt.iterator(this, in, charset);
        }
        catch (Exception ex) {
            this.logException(ex);
            throw ex;
        }
    }

    public void registerTranslation(T entryContents) throws Exception {
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(this.urlSave).openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            if (this.headers.get("Accept") == null) {
                connection.setRequestProperty("Accept", "text/plain");
            }
            String args = "";
            for (Map.Entry<String, String> entry : this.encodeArgs(entryContents).entrySet()) {
                args = args + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8") + "&";
            }
            connection.setRequestProperty("Content-Length", "" + args.getBytes("UTF-8").length);
            connection.setUseCaches(false);
            this.logMessage("http", "POST " + this.urlSave);
            this.logMessage("http", args);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            outputStreamWriter.write(args);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith(";")) continue;
                int index = line.indexOf("ERROR");
                if (index > 0) {
                    this.logMessage("", line.substring(index + 6));
                    throw new Exception(this.getProviderName() + " / " + this.getMemoryName() + ": " + line.substring(index + 6));
                }
                index = line.indexOf("FAIL");
                if (index <= 0) continue;
                this.logMessage("", line.substring(index + 5));
                throw new Exception(this.getProviderName() + " / " + this.getMemoryName() + ": " + line.substring(index + 5));
            }
            connection.disconnect();
            this.logEntry("update-contents", entryContents, false);
        }
        catch (IOException e) {
            this.logException(e);
            throw e;
        }
    }

    protected abstract Map<String, String> encodeArgs(T var1);
}

