-- DESCRIPTION
-- 	This is the base tables for Cyclotis database
--	This file contains only tables which are independent from the mode
--	Other tables may be copies (example : create table table2 (like mem))
--	or derivatives (example: create table mem2() inherits (mem))

-- Basic memory : stores author and date
CREATE TABLE mem (
    author character varying(12),
    date timestamp DEFAULT now() NOT NULL
)
 inherits (tra);

-- Memory which accepts modification of a segment
-- Such a table can be used two ways :
-- 1. with a replace rule: 
-- 		when we insert a new segment with same source text, 
--			it replaces the previous one and CHANGEDATE/CHANGER are set
--		(date,author) refer to the first insertion, (changer,changedate) to the last one.
-- 2. as a versionned table:
-- 		when we insert a new segment with same source text, 
--			we also update changer/changedate of the previous version.
--		when we delete a segment, the database simply sets (changer,changedate) instead
--		(date,author) refer to insertion of this version,(changer,changedate) refer to end od validity
CREATE TABLE memup (
    changer character varying(12) NULL,
    changedate timestamp NULL
)
    inherits (mem);

-- Memory similar to a TMX: contains properties and note
--	Format of props is to be decided by your client    
CREATE TABLE memx (
     props text null,
     note text null
)
    inherits (memup);
	
-- Glossary : does not store author/date but can have props and note
CREATE TABLE glos (
     props text null,
     note text null
)
    inherits (tra);

-- Glossary with id. Used if your CAT tool does separate search for each language
-- Note. Serial value is shared between all inheriting tables, meaning that any value may appear only once.
--	This is not formerly a key, but you should avoid to re-use an existing value.
CREATE TABLE glosid (
	row_id serial not null
)
	inherits (glos);
	

CREATE TABLE users (
	-- id serial not null,				-- used only if there are references
	login text not null,
	password text not null
	-- , usergroup text not null
	-- , schema text not null			-- used when users are distinct by schema
);

	
-- LICENCE
--
--  Copyright 2013-2016 Silvestris Project (http://www.silvestris-lab.org/)
--
--  Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
--  You may not use this work except in compliance with the Licence.
--  You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl
--
--  Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the Licence for the specific language governing permissions and limitations under the Licence. 
