#! /usr/bin/env perl

=head1 test-createTable.pl

Tests db/TableCreator.pm/recursive_create_table(...)

Warning: this test works with all modes except by_code and its variants.

=cut

use lib '../db';
use DbCreator;
use TableCreator;

my $dbh = 'DBI_Emulator'; my $spec1, $spec2;
if ($spec1 = shift) {	# Tries to do it in a real database
	require DBI;
	my $dbiSpec = &DbCreator::analyse_dbSpec($spec1); # internal format -> dbi string
	my ($user, $pass);
	if ($dbSpec =~ s/username=(.+?)(;|$)// or $dbiString =~ s/username=(.+?)(;|$)//) { $user = $1; }
	if ($dbSpec =~ s/password=(.+?)(;|$)// or $dbiString =~ s/password=(.+?)(;|$)//) { $pass = $1; }
	$dbh = DBI->connect($dbiSpec,$user,$pass);
	$dbh->do ("create type json as enum('a','b')") unless $dbh->{pg_server_version} >= 90200;
}

$main::ENV{CYCLOTIS_PROPS_TYPE} = $main::ENV{CYCLOTIS_CONTEXT_TYPE} = 'text'; $main::ENV{CYCLOTIS_TEXT_LEN} = '';	# Ensure the test has always same result

my $mode = $ENV{CYCLOTIS_MODE} || 'by_void'; $mode .= '::TableCreator'; eval "require $mode";
my $TableCreator = bless { dbh => $dbh, dbiSpec => $spec1 }, $mode;
$mode->loadTables('../db');		# No database connection

print STDERR " 		-- Test 1. Using environment defined by variables ---\n";
print STDERR " 	-- Test 1A. Using environment defined by variables ---\n";


# Test 1A1. Without any parameter, no change
my $res = $TableCreator->replacedTableName('MEMX');
print STDERR "1A1.\treplacedTableName(MEMX) = $res\n"; die "Incorrect" unless $res eq 'public.memx';

# Test 1A2. With parameters as TEXT, identical to environment, no change
$res = $TableCreator->replacedTableName('MEMX', 'type:props' => 'TEXT');
print STDERR "1A2.\treplacedTableName(MEMX, type:props = text) = $res\n"; die "Incorrect" unless $res eq 'public.memx';

# Test 1A3. With parameter as JSON
$res = $TableCreator->replacedTableName('MEMX', 'type:props' => 'JSON');
print STDERR "1A3.\treplacedTableName(MEMX, type:props = json) = $res\n"; die "Incorrect" unless $res eq 'public.memx_j';
if ($TableCreator::reqStr{TABLE}{'public.memx_j'} =~ /JSON/i) { print STDERR "MEMX_J : Query OK\n"; } else { print STDERR "public.memx_j : query error\n", $DbCreator::reqStr{TABLE}{'public.memx_j'}, "\n"; }
if ($TableCreator::reqStr{TABLE}{'public.memx_h'}) { print STDERR "MEMX_H already exists\n"; } else { print STDERR "public.memx_h : not yet created\n"; }

# Test 1A4. Test that CONTEXT changes nothing for table which does not contain it
$res = $TableCreator->replacedTableName('MEMX', 'type:props' => 'JSON', 'type:context' => 'brol');
print STDERR "1A4.\treplacedTableName(MEMX, type:props = json, type:context = brol) = $res\n"; die "Incorrect" unless $res eq 'public.memx_j';

# Test 1A5. Test with context only
$res = $TableCreator->replacedTableName('MEMID', 'type:context' => 'int');
print STDERR "1A5.\treplacedTableName(MEMID, type:context = int) = $res\n"; die "Incorrect" unless $res eq 'public.memid_i';
print STDERR "\n\n";

# Test 1A6. Tables are case insensitive
$res =$TableCreator->replacedTableName('memid', 'type:context' => 'int');
print STDERR "1A6.\treplacedTableName(memid, type:context = int) = $res\n"; die "Incorrect" unless $res eq 'public.memid_i';
$res = $TableCreator->replacedTableName('Memid', 'type:context' => 'int');
print STDERR "1A6.\treplacedTableName(Memid, type:context = int) = $res\n"; die "Incorrect" unless $res eq 'public.memid_i';
print STDERR "\n\n";

# Test 1A7. Can use replacedTableName with schema.table_name
$res = $TableCreator->replacedTableName('public.memid', 'type:context' => 'int');
print STDERR "1A7.\treplacedTableName(public.memid, type:context = int) = $res\n"; die "Incorrect" unless $res eq 'public.memid_i';
$res = $TableCreator->replacedTableName('other.memid', 'type:context' => 'int');
print STDERR "1A7.\treplacedTableName(other.memid, type:context = int) = $res\n"; die "Incorrect" unless $res eq 'other.memid';		# does not replace for other schema
print STDERR "\n\n";


print STDERR " 	-- Test 1B. Test recursive_create_table ---\n";

my $stdInerhit = $mode->can_inherit('public.memx','public.memid') ? 'MEMX,MEMID' : 'MEMID'; 
my $persoInherit = $mode->can_inherit('x.test1'); my $persoInheritMul = $mode->can_inherit('x.test1','x.test2');


# 	-- Test 1B. Test recursive_create_table
$TableCreator->doCreate_table('test01_simple', 'MEM');
$TableCreator->doCreate_table('test11_memx', 'MEMX');
$TableCreator->doCreate_table('test12_mul_std', $stdInerhit) if $stdInherit =~ /,/;
$TableCreator->doCreate_table('test21_hstore', $stdInerhit, 'props=hstore');
$TableCreator->doCreate_table('test22_json', $stdInerhit, 'props=json', 'context=int');
$TableCreator->doCreate_table('test23_json_sub1', 'test22_json') if $persoInherit;
$TableCreator->doCreate_table('test24_json_sub1_sub1', 'test23_json_sub1') if $persoInherit;
$TableCreator->doCreate_table('test31_mul_local', 'test01_simple,test11_memx') if $persoInheritMul;
$TableCreator->doCreate_table('TEST41_TABLE_UPPER', 'MEM', );
$TableCreator->doCreate_table('TEST42_Table_UcFirst', 'MEM');
$TableCreator->doCreate_table('test43_parent_lc', 'mem');
$TableCreator->doCreate_table('test44_parent_UcFirst', 'Mem');
$TableCreator->doCreate_table('public.test51_schema_public', 'Mem');
$dbh->do ("create schema scm");
$TableCreator->doCreate_table('scm.test52_schema_other', 'Mem');
$TableCreator->doCreate_table('scm.test521_inertit_scm', 'scm.test52_schema_other');
$TableCreator->doCreate_table('scm.test53_inertit_public', 'test51_schema_public');
$TableCreator->doCreate_table('test6_tinfo', 'MEMX', 'tool_info=hstore');
$TableCreator->doCreate_table('test81_2langs', 'mem', 'srcLang=fr', 'tra_lang=de');
$TableCreator->doCreate_table('test82_1lang', 'memx', 'tra=fr');

eval { $TableCreator->doCreate_table('test82_1lang', 'memx', 'tra=fr'); }; $@;	# Test what happens if we create twice the same table

if ($TableCreator::reqStr{TABLE}{'public.memx_h'} =~ /HSTORE/i) { print STDERR "MEMX_H: Query OK\n"; } else { print STDERR "public.memx_h : query error\n", $DbCreator::reqStr{TABLE}{'public.memx_h'}, "\n"; }
if ($TableCreator::reqStr{TABLE}{'public.memid_i'} =~ /INT/i) { print STDERR "MEMID_I: Query OK\n"; } else { print STDERR "public.memid_i : query error\n", $DbCreator::reqStr{TABLE}{'public.memid_i'}, "\n"; }

print STDERR "\n\n";

# 	-- Test 2. Changing environment
%TableCreator::reqStr = (); %TableCreator::realTypes = (); 
$main::ENV{CYCLOTIS_PROPS_TYPE} = $main::ENV{CYCLOTIS_TOOL_INFO_TYPE} = 'hstore';
$mode->loadTables('../db');		# No database connection

if ($TableCreator::reqStr{TABLE}{'public.memx'} =~ /props\s+(.+)\s+null/) { $res = $1; print STDERR "Now props = $1\n"; die "Incorrect" unless $res =~ /hstore/; }

$res = $TableCreator->replacedTableName('MEMX', 'type:props' => 'HSTORE');
print STDERR "2A1.\treplacedTableName(MEMX, type:props = HSTORE) = $res\n"; die "Incorrect" unless $res eq 'public.memx';

$res = $TableCreator->replacedTableName('MEMX', 'type:props' => 'TEXT');
print STDERR "2A2.\treplacedTableName(MEMX, type:props = text) = $res\n"; die "Incorrect" unless $res eq 'public.memx_t';

if ($spec2 = shift) {	# Second database
	require DBI;
	my $dbiSpec = &DbCreator::analyse_dbSpec($spec2); # internal format -> dbi string
	my ($user, $pass);
	if ($dbiSpec =~ s/username=(\w+)//) { $user = $1; }
	if ($dbiSpec =~ s/password=(\w+)//) { $pass = $1; }
	$dbh = DBI->connect($dbiSpec,$user,$pass);	
	$dbh->do ("create type json as enum('a','b')") unless $dbh->{pg_server_version} >= 92000;
	$TableCreator = bless { dbh => $dbh, dbiSpec => $spec2 }, ref($TableCreator);
} elsif (ref($dbh)) {
	exit; # Cannot continue the tests in the same real database
}

%DBI_Emulator::tables = (); $DBI_Emulator::state = undef;

# Test 8. Test recursive_create_table with ENV{CYCLOTIS_PROPS_TYPE} = hstore
$TableCreator->doCreate_table('test1_simple', 'MEM');	# should give same result as before
$TableCreator->doCreate_table('test2_memx', 'MEMX');	# same result as before, except that MEMX.PROPS = hstore
$TableCreator->doCreate_table('test3_mul_std', $stdInerhit) if $stdInherit =~ /,/;	# same result as before, except that MEMX.PROPS = hstore
$TableCreator->doCreate_table('test4_hstore', $stdInerhit, 'props=hstore');	# contrarily to other db, since type:props = hstore we extend MEMX
$TableCreator->doCreate_table('test4_json', $stdInerhit, 'props=json');	# should indeed extend memx_j
$TableCreator->doCreate_table('test4_text', $stdInerhit, 'props=text');	# should indeed extend memx_t
$TableCreator->doCreate_table('test5_json', $stdInerhit, 'props=json', 'context=int');	# Same result as before
$TableCreator->doCreate_table('test5_json_sub1', 'test5_json') if $persoInherit;
$TableCreator->doCreate_table('test5_json_sub1_sub1', 'test5_json_sub1') if $persoInherit;
$TableCreator->doCreate_table('test6_tinfo', 'MEMX', 'tool_info=hstore');
$TableCreator->doCreate_table('test7_mul_local', 'test1_simple,test2_memx') if $persoInheritMul;


package DBI_Emulator;

our %tables = (); our $state;

sub do {
	shift; my $req = shift; 
	print STDERR "DBI_Emulator->do $req\n";
	if ($req =~ /TABLE\s*([\w\.]+)\b/i) {
		my $table = lc($1); $table = "public.$table" unless $table =~ /\./;
		if ($DBI_Emulator::tables{$table}) { $state = '42P07'; return 0; }
		my @parents = split(/,/,$1) if $req =~ /inherits\s*\((.+?)\)/;
		foreach my $p (@parents) { $p = "public.$p" unless $p =~ /\./; unless ($DBI_Emulator::tables{$p}) { $state = '42P01'; return 0; } }
		$state = '00P00'; return $DBI_Emulator::tables{$table} = 1;	
	} else {
		$state = '00P00'; return 1;
	}
}

sub state {
	$state
}

our $cpt = 0;
sub last_insert_id { ++$cpt }

sub prepare { my ($self, $req) = @_; return bless \$req, 'DBI_Emulator::req'; }

package DBI_Emulator::req;

sub execute { 1 }
sub fetchrow_array { () }

1;
