#! /usr/bin/env ruby 


if ARGV.count < 1
    puts "Syntax: #{__FILE__} <xliff>"
    exit
end


file = ARGV.shift

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'spongiae/unit'
require 'spongiae/xliff'

require 'spongiae/stats'
statsSrc = Spongiae::Stats::SegmentsStatsRow.new; statsTra = Spongiae::Stats::SegmentsStatsRow.new


Spongiae::XLIFF::read_units(file,false) do |unit|
    statsSrc.add_unit unit.srcText
    statsTra.add_unit unit.traText unless unit.traText == nil
end

def put_stats(stats)
    puts "Units: #{stats.units}"
    puts "Words: #{stats.words}"
    puts "Characters: #{stats.chars}"
    puts "Non-blank characters: #{stats.nbChars}"
end

puts "Original:"
put_stats(statsSrc)
puts "Translated:"
put_stats(statsTra)


