require 'spongiae/unit'
require 'digest/sha1'

module Spongiae
   module Formats
       
       class GettextPo
           
           def initialize(file, props = {})
               @file = file
               if props[:encoding] != nil then @encoding = props[:encoding] else @encoding = 'UTF-8' end
               if props[:includeDeleted] != nil then @incDeleted = props[:includeDeleted] else @incDeleted = false end
           end
           
           # read_strings : build unit for each string
           # For Plain Text, this is one string per line.
           def read_unit(&sub)
               File.open(@file, "r:#{@encoding}") do |f|
                   src = ''; tra = ''; ctxt = ''; where = ''; @nPlurals = 1
                   isDeleted = isFuzzy = isPlural = false
                   props = Spongiae::Unit::PropertiesArray.new
                   loop do 
                       line = f.gets
                       isFuzzy = true if line =~ /^(\#,)/ and line =~ /fuzzy/ 
                       isFuzzy = true if line =~ /^(\#\~?\|)/
                       isPlural = true if line =~ /msgid_plural "/
                       @nPlurals = $1.to_i - 1 if line =~ /Plural-Forms:\s*nplurals=\s*(\d+);/
                       if line =~ /^(\#\S+ )?msgctxt "(.+)"/ then 
                           # if @incDeleted and isFuzzy, use fuzzy context (#~| msgctxt) if exists. Else use current context
                           if not(@incDeleted) or not(isFuzzy and ctxt.length > 0) then
                               ctxt = $2 ; where = ctxt
                           else
                               where = ''   # we don't use this line so next line should go to /dev/null
                           end
                       end
                       if line =~ /^(\#\S+ )?msgid "(.+)"/ then
                           # Same rule as for context
                           if not(@incDeleted) or not(isFuzzy and src.length > 0) then
                               src = $2 ; where = src
                           else
                               where = ''   # we don't use this line so next line should go to /dev/null
                           end
                           isDeleted = true if ($1 =~ /\~/)
                       end
                       if line =~ /^(\#\S+ )?msgstr "(.+)"/ then tra = $2; where = tra; end
                       if line =~ /^(\#\S+ )?msgstr\[(\d+)\] "(.+)"/ then 
                           isPlural = true  # even without msgid_plural
                           tra = Array.new unless tra.is_a? Array
                           tra[$2.to_i] = $3
                           where = tra[$2.to_i] 
                       end
                       props['reference'] = $1 if line =~ /^\#\: (.+)\r?\n/     # can be multiple
                       props['note'] = $1 if line =~ /^\# (.+)\r?\n/     # can be multiple
                           
                       if line =~ /^(\#\S+ )?"(.+)"/ then where << $2 end
                    
                       if line == nil or line =~ /^\r?\n$/
                            break if isDeleted and not @incDeleted
                            props['ctxt'] = ctxt
                            if isPlural then
                                if tra.is_a? Array then
                                    tra.each_with_index do |item,id|
                                        props = props.copyWith('plural-form', id.to_s)  # copy because multiple entries will receive distinct copies
                                        yield Spongiae::Unit::Bilingual.new(@file, Digest::SHA1.hexdigest("#{ctxt}::#{src}::[#{id}]"), props,  
                                                                            extract_placeables(src),extract_placeables(item)) 
                                    end
                                else    # set plural but did not contain msgstr[]
                                    props = props.copyWith('plural-form', 0)  # copy because multiple entries will receive distinct copies
                                    yield Spongiae::Unit::Bilingual.new(@file, Digest::SHA1.hexdigest("#{ctxt}::#{src}::[0]"), props, 
                                                                        extract_placeables(src),extract_placeables(tra)) 
                                    (1 .. @nPlurals).each do |id|
                                        # Generate with empty string to be sure we can translate it
                                        props = props.copyWith('plural-form', id.to_s)  # copy because multiple entries will receive distinct copies
                                        yield Spongiae::Unit::Bilingual.new(@file, Digest::SHA1.hexdigest("#{ctxt}::#{src}::[#{id}]"), props,
                                                                            extract_placeables(src),'') 
                                    end
                                end
                            else
                                yield Spongiae::Unit::Bilingual.new(@file, Digest::SHA1.hexdigest("#{ctxt}::#{src}"), props, 
                                                                    extract_placeables(src),extract_placeables(tra)) 
                            end
                            src = ''; tra = ''; ctxt = ''; where = ''
                            break if line == nil
                            isDeleted = isFuzzy = false
                            props = Spongiae::Unit::PropertiesArray.new
                       end
                   end
               end
           end
           
           def translate(dest_file_name,translations_map,props={})
              File.open(dest_file_name, 'w:UTF-8') do |dest|
                  read_unit do |unit|
                      tra = unit.traText
                      tra = translations_map[unit.id] if translations_map[unit.id] != nil
                      dest.puts "msgctxt \"#{unit.props['ctxt']}\"" if unit.props['ctxt'] != nil and unit.props['ctxt'].length > 0
                      dest.puts "msgid \"#{unit.srcText.to_native_xml}\""
                      if not unit.props.key? "plural-form" then
                          dest.puts "msgstr \"#{tra.to_native_xml}\""
                      elsif unit.props["plural-form"] == "0" then
                          dest.puts "msgstr[0] \"#{tra.to_native_xml}\""
                          (1 .. @nPlurals).each do |i|
                              id = Digest::SHA1.hexdigest("#{unit.props['ctxt']}::#{unit.srcText}::[#{i}]")
                              tra = translations_map[id] if translations_map[id] != nil
                              dest.puts "msgstr[#{i}] \"#{tra.to_native_xml}\""
                          end
                      end
                      dest.puts ""
                  end
              end
           end
           
           def extract_placeables(st)
               tags = []; shift = 0
               st = st.gsub(/\%(\d+\$)?([\+\-])?(\d+)?(\.\d+)?[bBhHsSiIcCdoxXeEfgGaAtTn]/) do 
                  match = Regexp.last_match
                   tags << Spongiae::Tags::Placeable.new(match.begin(0) - shift, Spongiae::Tags::PlaceHolder.new(match[0], tags.count + 1))
                  ''
                  shift += match[0].length
               end
               return tags.empty? ? st : Spongiae::Tags::TaggedString.new(st,tags)
           end
           
       end
       
   end
end
