/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.silvestrislab.cyclotis.omegat.Cyclotis;

public abstract class PostgresqlCyclotis<T>
extends Cyclotis<T> {
    private static final Map<String, Connection> pool = new HashMap<String, Connection>();
    protected Connection connection;
    protected PreparedStatement pSelect;
    protected PreparedStatement pInsert;
    protected String tableRead;
    protected String tableWrite;
    protected Object mem_id = null;
    protected boolean hasNote = false;
    private String metaInfoTableName;

    public PostgresqlCyclotis(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        String jdbc;
        String pass;
        String driver = propList.getProperty("jdbc.driver");
        if (driver == null) {
            driver = "org.postgresql.Driver";
        } else if (driver.contains(",")) {
            String[] drivers = driver.split(",");
            for (int i = 0; i < drivers.length - 1; ++i) {
                Class.forName(drivers[i]);
            }
            driver = drivers[drivers.length - 1];
        }
        Class.forName(driver);
        String user = propList.getProperty("jdbc.user");
        if (user == null) {
            user = propList.getProperty("user");
        }
        if ((pass = propList.getProperty("jdbc.password")) == null) {
            pass = propList.getProperty("password");
        }
        if ((jdbc = propList.getProperty("jdbc.url")) == null) {
            jdbc = propList.getProperty("jdbc");
        }
        if (jdbc == null) {
            String host = propList.getProperty("jdbc.host");
            String port = propList.getProperty("jdbc.port");
            String db = propList.getProperty("jdbc.db");
            if (host == null) {
                host = "localhost";
            }
            if (port != null) {
                host = host + ":" + port;
            }
            jdbc = "jdbc:postgresql://" + host + "/" + db;
            if ("true".equals(propList.getProperty("jdbc.ssl"))) {
                jdbc = jdbc + "?ssl=true";
            }
        }
        this.connection = pool.get(jdbc);
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(jdbc, user, pass);
            pool.put(jdbc, this.connection);
        }
        this.tableWrite = propList.getProperty("table");
        if (this.tableWrite == null) {
            this.tableWrite = propList.getProperty("table.write");
            if (this.tableWrite == null) {
                this.tableWrite = "MEM";
            }
        }
        this.tableRead = propList.getProperty("table.read");
        if (this.tableRead == null) {
            this.tableRead = this.tableWrite;
        }
        this.metaInfoTableName = propList.getProperty("table.meta");
        this.logMessage("", "Connection to " + this.name + " as " + jdbc + " OK.");
        PreparedStatement pColumnInfo = this.connection.prepareStatement("select column_name, udt_name, udt_schema, character_maximum_length, column_default from INFORMATION_SCHEMA.COLUMNS where table_name = ? and table_schema = ? and table_catalog = current_catalog");
        if (this.tableWrite.contains(".")) {
            pColumnInfo.setString(1, this.tableWrite.substring(this.tableWrite.indexOf(".") + 1).toLowerCase());
            pColumnInfo.setString(2, this.tableWrite.substring(0, this.tableWrite.indexOf(".")).toLowerCase());
        } else {
            pColumnInfo.setString(1, this.tableWrite.toLowerCase());
            pColumnInfo.setString(2, "public");
        }
        ResultSet set = pColumnInfo.executeQuery();
        while (set.next()) {
            this.registerColumn(set, propList);
        }
        pColumnInfo.close();
    }

    protected PostgresqlCyclotis(PostgresqlCyclotis ori) {
        super(ori);
        this.connection = ori.connection;
        this.tableRead = ori.tableRead;
        this.mem_id = ori.mem_id;
        this.hasNote = ori.hasNote;
        this.metaInfoTableName = ori.metaInfoTableName;
    }

    protected void registerColumn(ResultSet set, Properties propList) throws SQLException {
        block14: {
            String colName = set.getString("column_name").toUpperCase();
            if (colName.equalsIgnoreCase("NOTE")) {
                this.hasNote = true;
            }
            if (colName.toUpperCase().startsWith("MEM_")) {
                try {
                    if (!this.tableRead.equalsIgnoreCase(this.tableWrite)) {
                        this.logMessage("", "We use inheritance, so we must store " + colName);
                        throw new Exception();
                    }
                    if (colName.equalsIgnoreCase("MEM_ID")) {
                        int fix = Integer.parseInt(set.getString("column_default"));
                        this.logMessage("", "Table " + this.tableWrite + " has MEM_ID with default " + fix + ": not saved");
                        break block14;
                    }
                    if (colName.equalsIgnoreCase("MEM_CODE")) {
                        long fix = Long.parseLong(set.getString("column_default"));
                        this.logMessage("", "Table " + this.tableWrite + " has MEM_ID with default " + fix + ": not saved");
                        break block14;
                    }
                    if (!colName.equalsIgnoreCase("MEM_PATH")) break block14;
                    String col_default = set.getString("column_default");
                    if (col_default != null && col_default.length() > 0) {
                        this.logMessage("", "Table " + this.tableWrite + " has MEM_PATH with default " + col_default + ": not saved");
                        break block14;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    ResultSet set1 = this.getInfoResultSet(colName);
                    while (set1.next()) {
                        if (colName.equalsIgnoreCase("MEM_ID")) {
                            this.mem_id = set1.getInt(1);
                        } else if (colName.equalsIgnoreCase("MEM_CODE")) {
                            this.mem_id = set1.getLong(1);
                        } else if (colName.equalsIgnoreCase("MEM_PATH")) {
                            this.mem_id = set1.getString(1);
                        }
                        this.logMessage("", "Table " + this.tableWrite + " has " + colName + ", declared as " + this.mem_id);
                    }
                }
            }
        }
    }

    protected ResultSet getInfoResultSet(String name) throws SQLException {
        if (this.metaInfoTableName == null) {
            this.metaInfoTableName = this.findInfoTableName();
        }
        PreparedStatement pId = this.connection.prepareStatement("select " + name + " from public.meta_info where table_name = ? and table_schema = ?");
        if (this.tableWrite.contains(".")) {
            pId.setString(1, this.tableWrite.substring(this.tableWrite.indexOf(46) + 1));
            pId.setString(2, this.tableWrite.substring(0, this.tableWrite.indexOf(46)));
        } else {
            pId.setString(1, this.tableWrite);
            pId.setString(2, "public");
        }
        return pId.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findInfoTableName() throws SQLException {
        Statement stmt = this.connection.createStatement();
        try {
            ResultSet set = stmt.executeQuery("select table_name from information_schema.tables where table_schema  = 'public'");
            while (set.next()) {
                if (set.getString(1).equalsIgnoreCase("meta_view")) {
                    String string = "public.meta_view";
                    return string;
                }
                if (set.getString(1).equalsIgnoreCase("meta_info")) {
                    String string = "public.meta_info";
                    return string;
                }
                if (!set.getString(1).equalsIgnoreCase("options")) continue;
                String string = "public.options";
                return string;
            }
        }
        finally {
            stmt.close();
        }
        throw new SQLException("Did not find table for meta info");
    }

    protected abstract T buildEntry(ResultSet var1) throws SQLException;

    protected List<T> retreiveQuery(PreparedStatement query) throws SQLException {
        LinkedList<T> theList;
        block5: {
            theList = new LinkedList<T>();
            try {
                ResultSet set = query.executeQuery();
                while (set.next()) {
                    try {
                        theList.add(this.buildEntry(set));
                    }
                    catch (SQLException sqlIn) {
                        this.logMessage("", "While retreiving result:");
                        this.logException(sqlIn);
                    }
                }
                set.close();
            }
            catch (SQLException sqlOut) {
                this.logMessage("", "After retreiving result:");
                this.logException(sqlOut);
                if (!theList.isEmpty()) break block5;
                throw sqlOut;
            }
        }
        this.logMessage("search", "returned " + theList.size() + " entries");
        return theList;
    }

    protected Iterable<T> iterateQuery(final PreparedStatement stmt) throws SQLException {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    return new Iterator<T>(){
                        private boolean didNext = false;
                        private boolean hasNext = false;
                        private ResultSet set;
                        {
                            this.set = stmt.executeQuery();
                        }

                        @Override
                        public T next() {
                            try {
                                if (!this.didNext) {
                                    this.set.next();
                                }
                                this.didNext = false;
                                return PostgresqlCyclotis.this.buildEntry(this.set);
                            }
                            catch (SQLException sqlEx) {
                                PostgresqlCyclotis.this.logException(sqlEx);
                                return null;
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            try {
                                if (!this.didNext) {
                                    this.hasNext = this.set.next();
                                    this.didNext = true;
                                }
                                if (!this.hasNext) {
                                    this.set.close();
                                }
                            }
                            catch (SQLException sqlEx) {
                                PostgresqlCyclotis.this.logException(sqlEx);
                            }
                            finally {
                                return this.hasNext;
                            }
                        }
                    };
                }
                catch (Exception e) {
                    PostgresqlCyclotis.this.logException(e);
                    return Collections.emptyIterator();
                }
            }
        };
    }

    protected abstract String selectCondition();

    protected final String getSelectFrom() {
        if (!this.tableRead.equals(this.tableWrite) && this.mem_id != null) {
            if (this.mem_id instanceof Integer) {
                return "select *, concat(m.table_schema,'.',m.table_name) as mem_name   from " + this.tableRead + " t left join " + this.metaInfoTableName + " m on t.mem_id = m.mem_id";
            }
            if (this.mem_id instanceof Long) {
                return "select *, concat(m.table_schema,'.',m.table_name) as mem_name   from " + this.tableRead + " t left join " + this.metaInfoTableName + " m on t.mem_code = m.mem_code";
            }
            if (this.mem_id instanceof String) {
                return "select *, substring(MEM_PATH from E'/([^/]+?)$') as mem_name from " + this.tableRead;
            }
        }
        return "select * from " + this.tableRead;
    }

    protected final PreparedStatement getSelectStatement() throws SQLException {
        if (this.pSelect == null) {
            String sql = this.getSelectFrom() + " where " + this.selectCondition();
            this.logMessage("sql", "Select statement = " + sql);
            this.pSelect = this.connection.prepareStatement(sql);
        }
        return this.pSelect;
    }

    protected abstract List<String> insertFields();

    protected String getInsertFieldType(String name) {
        return "";
    }

    protected PreparedStatement getInsertStatement() throws SQLException {
        if (this.pInsert == null) {
            int i;
            StringBuffer insertBuf = new StringBuffer("insert into ").append(this.tableWrite).append("(");
            List<String> fields = this.insertFields();
            for (i = 0; i < fields.size(); ++i) {
                insertBuf.append(fields.get(i));
                if (i >= fields.size() - 1) continue;
                insertBuf.append(",");
            }
            insertBuf.append(") values (");
            for (i = 0; i < fields.size(); ++i) {
                insertBuf.append("?");
                String type = this.getInsertFieldType(fields.get(i));
                if (!type.equals("")) {
                    insertBuf.append("::").append(type);
                }
                if (i >= fields.size() - 1) continue;
                insertBuf.append(",");
            }
            insertBuf.append(")");
            this.logMessage("sql", "Insert statement = " + insertBuf);
            this.pInsert = this.connection.prepareStatement(insertBuf.toString());
            if (this.mem_id != null) {
                if (this.mem_id instanceof Integer) {
                    this.pInsert.setInt(fields.size(), (Integer)this.mem_id);
                } else if (this.mem_id instanceof Long) {
                    this.pInsert.setLong(fields.size(), (Long)this.mem_id);
                } else if (this.mem_id instanceof String) {
                    this.pInsert.setString(fields.size(), this.mem_id.toString());
                }
            }
        }
        return this.pInsert;
    }
}

