/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.Language;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.proj.EntryKeyStore;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;
import org.silvestrislab.cyclotis.omegat.tm.HttpMemory;

public class HttpProjectMemory
extends HttpCyclotisTMX<ProjectMemory.ContextTMXEntry>
implements ProjectMemory.IConvertibleExternalProjectMemory {
    public static final int COL_CONTEXT = 8;
    public final EntryKeyStore keyStore;
    public final StringContextMode contextMode;
    private long timeStampDiff;

    public HttpProjectMemory(Properties propList) {
        super(propList);
        this.keyStore = new EntryKeyStore(propList);
        this.logMessage("struct", "Storing properties as " + this.keyStore);
        this.contextMode = StringContextMode.forProperties(propList, 1);
        this.logMessage("struct", "Context mode  is " + this.contextMode);
        try {
            String serverTime = propList.getProperty("server-time");
            if (serverTime.contains(";")) {
                serverTime = serverTime.substring(0, serverTime.indexOf(59));
            }
            this.timeStampDiff = Long.parseLong(serverTime) - System.currentTimeMillis();
            this.logMessage("", "Server to client timestamp difference: " + this.timeStampDiff);
        }
        catch (Exception e) {
            this.logMessage("", "Cannot find server timestamp : " + e.getMessage());
        }
    }

    public IExternalMemory asTranslationMemory() {
        return new HttpMemory(this){

            @Override
            public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
                this.logMessage("search", "Searching for '" + text + "'");
                List<PrepareTMXEntry> res = this.httpGetAll("fuzzy", "otadcupniN", this.reduceWords(text));
                res.removeAll(Collections.singleton(null));
                return res;
            }

            @Override
            public PrepareTMXEntry analyzeLine(HttpOutputFormat fmt, Object args) {
                ProjectMemory.ContextTMXEntry ctx = HttpProjectMemory.this.analyzeLine(fmt, args);
                if (ctx.entryNum > 0) {
                    return null;
                }
                if (args instanceof String[]) {
                    String[] cols = (String[])args;
                    cols[8] = cols[9];
                }
                return super.analyzeLine(fmt, args);
            }
        };
    }

    @Override
    public ProjectMemory.ContextTMXEntry analyzeLine(HttpOutputFormat fmt, Object args) {
        return fmt.buildContextEntry(this, args);
    }

    public Iterable<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        this.logMessage("search", "Searching for segments after " + LONG_LOG_DATE_FORMAT.format(new Date(timeStamp + this.timeStampDiff)));
        if ((double)timeStamp < 1.0E9) {
            return this.httpGetIterable("all", "otadcupni", new Timestamp(timeStamp + this.timeStampDiff).toString());
        }
        return this.httpGetAll("all", "otadcupni", new Timestamp(timeStamp + this.timeStampDiff).toString());
    }

    @Override
    protected Map<String, String> encodeArgs(ProjectMemory.ContextTMXEntry entry) {
        Map<String, String> args = super.encodeArgs(entry);
        args.put("context", (String)this.contextMode.toDatabase(entry.entryNum, entry.isDefault));
        if (this.keyStore.shouldWrite(entry)) {
            for (TMXProp prop : this.keyStore.buildProperties(entry)) {
                args.put("props." + prop.getType(), prop.getValue());
            }
        }
        return args;
    }

    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        String line;
        StringBuffer urlString = new StringBuffer(this.urlSave);
        urlString.append("?context=").append((String)this.contextMode.toDatabase(entry.entryNum, entry.isDefault));
        if (!this.contextMode.isUnique()) {
            urlString.append("&src=").append(URLEncoder.encode(entry.source, "UTF-8"));
        }
        URL httpUrl = new URL(urlString.toString());
        HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("DELETE");
        BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = rd.readLine()) != null) {
            System.out.println("POST:" + line);
        }
        connection.disconnect();
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        this.logMessage("update", "Writing entry '" + entry.source + "'");
        if (entry.entryNum > 0) {
            entry.otherProperties = this.store.toDatabase((PrepareTMXEntry)entry, (SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1));
        }
        super.registerTranslation(entry);
    }
}

