/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2015-2017 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.http;

import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.proj.HttpProjectMemory;
import java.io.*;
import java.text.*;
import java.util.*;
import java.net.URLDecoder;

import org.omegat.util.TMXProp;
import org.omegat.core.data.TMXEntry.ExternalLinked;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.ProjectMemory.ContextTMXEntry;
import org.omegat.gui.glossary.GlossaryEntry;

public class LineFormat implements HttpOutputFormat {
	public LineFormat(String name) {
		int idx = name.indexOf("dateFormat");
		if (idx > 0) {
			name = name.substring(idx) + 11;
			if ((idx = name.indexOf(";")) > 0) name = name.substring(0, idx);
			if ((idx = name.indexOf("!")) > 0) {
				String lang = name.substring(0, idx), spec = name.substring(idx + 1);
				PSQL_DATE = new SimpleDateFormat(spec, new java.util.Locale(lang));
			}
		}
	}
	
	public String MIME() { return "text/plain"; }
	
	public <T> List<T> readFromGet (HttpCyclotis<T> cyclotis, InputStream is, String encoding) throws Exception {
		BufferedReader reader = new BufferedReader (new InputStreamReader(is,encoding));
		List<T> theList = new ArrayList<T>(); String line; String[] cols;
		while ((line = reader.readLine()) != null) {
			cyclotis.logMessage ("http-response", "HTTP: " + line);
			if (line.trim().length() == 0) continue;
			if (line.startsWith(";")) continue;
			if (line.startsWith("!")) {
				cyclotis.logMessage ("", "ERROR: " + line.substring(1).trim()); 
				if (theList.isEmpty()) throw new Exception (cyclotis.getProviderName() + "/" + cyclotis.getMemoryName() + ": " + line.substring(1).trim());
			}
			line += "|||||---"; cols = line.split("\\|"); 
			for (int i = 0; i < cols.length; i++)
				try { cols[i] = java.net.URLDecoder.decode (cols[i], "UTF-8"); } catch (Exception e) {}
			theList.add (cyclotis.analyzeLine (this, cols));
		}
		return theList;
	}
	
	public <T> Iterator<T> iterator (final HttpCyclotis<T> cyclotis, final InputStream is, final String encoding) {
		try {
			return new Iterator<T>() {
				BufferedReader reader = new BufferedReader (new InputStreamReader(is,encoding));
				String line = nextLine();
				
				public boolean hasNext() { return line != null; }
				
				private String nextLine() {
					try {
						line = reader.readLine();
						if (line == null) return line;
						if (line.startsWith(";")) return nextLine(); // ignore
						if (line.startsWith("!")) { cyclotis.logMessage ("", "ERROR: " + line.substring(1).trim()); return nextLine(); } 
						return line;
					} catch (IOException io) {
						cyclotis.logException(io); return line = null;
					}
				}
				
				public T next() {
					cyclotis.logMessage ("http-response", "HTTP: " + line);
					line += "|||||---"; String[] cols = line.split("\\|"); 
					for (int i = 0; i < cols.length; i++)
						try { cols[i] = java.net.URLDecoder.decode (cols[i], "UTF-8"); } catch (Exception e) {}
					T result = cyclotis.analyzeLine (LineFormat.this, cols);
					line = nextLine();
					return result;
				}
			};
		} catch (Exception e) {
			cyclotis.logException(e); return java.util.Collections.emptyIterator();
		}
	}
	
	public SimpleDateFormat PSQL_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", java.util.Locale.ENGLISH);
	
	private void fillEntry (HttpCyclotis<?> cyclotis, PrepareTMXEntry entry, String[] cols) {
		try {
			entry.source =  cyclotis.reformatText(URLDecoder.decode (cols[HttpCyclotis.COL_SRC]), true);
			entry.translation = cyclotis.reformatText(URLDecoder.decode (cols[HttpCyclotis.COL_TRA]), true);
			entry.creator = URLDecoder.decode (cols[HttpCyclotisTMX.COL_AUTHOR]);
			entry.creationDate = PSQL_DATE.parse (cols[HttpCyclotisTMX.COL_DATE]).getTime();
			entry.changer = URLDecoder.decode (cols[HttpCyclotisTMX.COL_CHANGER]);
			entry.changeDate = PSQL_DATE.parse (cols[HttpCyclotisTMX.COL_CHANGEDATE]).getTime();
			entry.note = URLDecoder.decode (cols[HttpCyclotisTMX.COL_NOTE]);
		} catch (Exception e) {
			// Properties not mandatory
		}
		if (cols[HttpProjectMemory.COL_PROPS].contains("=")) {
			String[] propsCol = cols[HttpProjectMemory.COL_PROPS].split("&"); 
			entry.otherProperties = new java.util.ArrayList<TMXProp>(propsCol.length);
			for (int i = 0; i < propsCol.length; i++) {
				String[] keyVal = propsCol[i].split("=");
				if (i == 0) keyVal[0] = keyVal[0].substring(1);
				if (i == propsCol.length - 1) keyVal[1] = keyVal[1].substring(0, keyVal[1].length() - 1);
				keyVal[0] =  URLDecoder.decode(keyVal[0]); keyVal[1] =  URLDecoder.decode(keyVal[1]);
				entry.otherProperties.add (new TMXProp (keyVal[0], keyVal[1]));
			}
		}
		else entry.otherProperties = new java.util.ArrayList<TMXProp>(); // may be filled later by other methods
	}	
	
	public PrepareTMXEntry buildTmxEntry (org.silvestrislab.cyclotis.omegat.tm.HttpMemory memory, Object args) {
		PrepareTMXEntry entry = new PrepareTMXEntry();
		String[] cols = (String[]) args;
		this.fillEntry (memory, entry, (String[]) cols);
		entry.otherProperties = memory.store.fromDatabase (entry.otherProperties, entry);
		entry.otherProperties.add (new TMXProp("db.table.name", cols[8]));
		return entry;		
	}
	
	public ContextTMXEntry buildContextEntry (HttpProjectMemory memory, Object args) {
		ContextTMXEntry entry = new ContextTMXEntry ();
		String[] cols = (String[]) args;
		this.fillEntry (memory, entry, cols);
		memory.keyStore.fillEntry(entry);
		memory.contextMode.fillEntry (memory, entry, cols[8]);

		try { entry.linked = ExternalLinked.valueOf (entry.getPropValue("externalLinked")); } catch (Exception e2) { }
		return entry;	
	}
	
	public GlossaryEntry buildGlossaryEntry(org.silvestrislab.cyclotis.omegat.Cyclotis memory, Object args,  boolean priority) {
		String[] cols = (String[]) args;
		if (cols[2] == null) cols[2] = ""; // in OmegaT 3.5.1, null may cause a bug
		for (int i = 0; i < cols.length; i++)
			try { cols[i] = java.net.URLDecoder.decode (cols[i], "UTF-8"); } catch (Exception e) {}
		return new GlossaryEntry (cols[0], cols[1], cols[2], priority, memory.getMemoryName());		
	}
	
}
