/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2013-2016 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.tm;

import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.util.Language;
import org.omegat.util.WikiGet;

import java.net.*;
import java.util.*;
import java.text.*;

public class HttpMemory extends HttpCyclotisTMX<PrepareTMXEntry> implements IWritableExternalMemory, IBrowsableMemory {

	protected static final String LINE_FORMAT = "otadcupnN";

	private SaveConditions conditions;
		
	public HttpMemory (Properties propList) {
		super(propList);
		if (propList.getProperty("update") != null) {
			String updateString = propList.getProperty("update");
			if (! (updateString.equalsIgnoreCase("false"))) {
				this.conditions = SaveConditions.forProperty(updateString);
			}
			else conditions = null;
		}
		else if (propList.getProperty("table.exclude") != null) {
			this.urlFind += "?exclude=" + propList.getProperty("table.exclude");
			this.conditions = null;
		}
		else conditions = null;
		System.out.println (getMemoryName() + ((this.conditions == null) ? " update = false" :  " update condition = " + conditions));
	}
	
	public HttpMemory (HttpCyclotisTMX ori) {
		super(ori);
		// do not copy save conditions, because we are read-only
	}
			
	/* ------------------ IExternalMemory ---------------*/

	public List<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
		logMessage("search", "Searching for <" + digest(text) + "> '" + text + "'");
		return httpGetAll("fuzzy", HttpMemory.LINE_FORMAT, reduceWords(text));
	}
		
	public PrepareTMXEntry analyzeLine (HttpOutputFormat fmt, Object args) {
		return fmt.buildTmxEntry(this, args);
	}
	
	/* ------------------ IWritableExternalMemory ---------------*/
	
	public boolean isWriteMode() {
		return (conditions != null);
	}
	
	public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
		return conditions.mustWrite (this, entryContents, entrySource);
	}	
	
	public  void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
		entryContents.otherProperties = store.toDatabase(entryContents, entrySource);
		registerTranslation(entryContents);
	}
	
	/* ------------------ ISearchableMemory ---------------*/	
	
	public Iterable<PrepareTMXEntry> search(SearchExpression expression)  throws Exception {
		String textExpr = searchExpressionText(expression); if (textExpr != null) return httpGetIterable(textExpr, HttpMemory.LINE_FORMAT, expression.text);
		if (expression.searchDateAfter) return httpGetIterable("all", HttpMemory.LINE_FORMAT, (new java.sql.Timestamp(expression.dateAfter)).toString());
		return getEntries();
	}
	
	private static String searchExpressionText (SearchExpression expression) {
		String field = "";
		if (expression.searchSource && expression.searchTarget && expression.searchNotes) field = "Any";
		else if (expression.searchSource && expression.searchTarget) field = "SegAny";
		else if (expression.searchSource && !expression.searchTarget && !expression.searchNotes) field = "Src";
		else if (!expression.searchSource && expression.searchTarget && !expression.searchNotes) field = "Tra";
		else if (!expression.searchSource && !expression.searchTarget && expression.searchNotes) field = "Note";
		else return null; // do not search at all in other cases.
		
		switch (expression.searchExpressionType) {
			case EXACT: 
				return (expression.caseSensitive ? "contains" : "icontains") + field;
			case KEYWORD: 
				return null; // do not implement keyword search
			case REGEXP:
				return (expression.caseSensitive ? "regex" : "iregex") + field;
		}
		return null;
	}
	
	
	public Iterable<PrepareTMXEntry> getEntries() throws Exception {
		logMessage("search", "Searching for all entries");
		return httpGetIterable("all", HttpMemory.LINE_FORMAT, "1900-01-01");
	}
}