/**************************************************************************
 Silvestris Cyclotis - Intermediate real-time translation memory server
 
 Copyright (C) 2013-2014 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is only a stub to enable compilation of Cyclotis plugin.
 
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/


package org.omegat.core.matching.external;

import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.Language;

/**
 * Interface for external translation memories (MyMemory, ...) in write mode
 * 
 * @author Thomas CORDONNIER
 */
public interface IWritableExternalMemory extends IExternalMemory {

	/** 
	 * Indicates that we really <b>want</b> to write 
	 * (IWritableExternalMemoryProvider only ensures that we <b>can</b>) <br>
	 * Called only during loading of the project or on reload of 'tm' directory:
	 * if false, the two next methods will never be called at all.
	 **/
	boolean isWriteMode();
	
	/** 
	 * Indicates that this entry has to be written in the database <br>
	 * Can be always true, or you may want to write only certain entries (for example, non-fuzzy ones). <br>
	 * registerTranslation will be called after, and only in case mustWrite is true <br>
	 * mustWrite should be a faster method than implementing conditions inside registerTranslation,
	 * and in case of error, it must return false, since it cannot throw an exception.
	 **/
	boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource);	

    /**
     * Send new translation to the provider 
	 * Note: we give to the provider all necessary information, 
	 * but the provider is free to use some of them or not.
     */
    void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception;
	
}
