#! /usr/bin/perl

=encoding utf-8
=head1 DESCRIPTION

This script returns size statistics about Elefas memory

=head1 USAGE

    perl ef-stats.pl DBI-String

=cut

use DBI;

my $db = shift or die "Syntax: $0 DBI-String";
$db = "dbname=$db" unless $db =~ /=/;
$db = "dbi:Pg:$db" unless $db =~ /^dbi:/i;

my $user = undef; $user = $1 if $db =~ s/\buser(?:name)?=(.+?)(;|$)//;
my $pass = undef; $pass = $1 if $db =~ s/\bpass(?:word)?=(.+?)(;|$)//;

my $conn = DBI->connect($db,$user,$pass);

foreach my $item ('doc', 'collection', 'unit') {
    my ($size) = $conn->selectrow_array("select count(*) from EF_$item");
    print "$item(s): $size\n";
}

$conn->disconnect;

=head1 LICENSE

Copyright 2013 Silvestris Project (L<http://www.silvestris-lab.org/>)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
