#! /usr/bin/ruby

if ARGV.count < 4
    puts "Syntax: "
    puts "\t#{__FILE__} DB-Name(:user:password)?(:host:port)? <import-dir> <search-input> <search-output>"
    exit
end

if ARGV[0] =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    $LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
    require 'musci'; Musci::add_aliases(config['memories']) 
end


db = ARGV.shift
importDir = ARGV.shift 
searchInputDir = ARGV.shift 
searchOutputDir = ARGV.shift

require 'date'
require 'fileutils'
require 'zip'

while true
    if Dir.empty?(importDir) and Dir.empty?(searchInputDir) then 
        sleep 5
    else
        Dir.each_child(importDir) do |file|
            puts "#{DateTime.now.strftime} - Found in #{importDir} file #{file}"            
            next unless file =~ /\.(tmx|zip)$/
            next unless File.file? "#{importDir}/#{file}"
            if file =~ /\.tmx$/ then
                FileUtils.mv("#{importDir}/#{file}", "/tmp/#{file}")
                system "#{File.dirname(__FILE__)}/ef-import.rb", db, "/tmp/#{file}"
                File.delete("/tmp/#{file}")
                puts "#{DateTime.now.strftime} - Imported file #{file}"            
            elsif file =~ /\.zip$/ then  # archive of xliff files
                puts "#{DateTime.now.strftime} - Merging file #{file}"            
                file.gsub! /\.zip$/, ''
                Dir.mkdir "/tmp/#{file}"
                Zip::File.open("#{importDir}/#{file}.zip") do |zip_file|
                    zip_file.each do |zentry|
                        fpath = File.join("/tmp/#{file}", zentry.name)
                        zip_file.extract(zentry, fpath) unless File.exist?(fpath)                    
                    end
                end
                File.delete("#{importDir}/#{file}.zip")
                system "#{File.dirname(__FILE__)}/sg_mergeToTmx.rb /tmp/#{file}.tmx /tmp/#{file}/*"
                system "rm", "-Rf", "/tmp/#{file}"
                puts "#{DateTime.now.strftime} - Importing file /tmp/#{file}.tmx"            
                system "#{File.dirname(__FILE__)}/ef-import.rb", db, "/tmp/#{file}.tmx"
                File.delete("/tmp/#{file}.tmx")
                puts "#{DateTime.now.strftime} - Imported file /tmp/#{file}.tmx"            
            end
        end        
        Dir.each_child(searchInputDir) do |file|
            puts "#{DateTime.now.strftime} - Found in #{searchInputDir} file #{file}"
            puts File.file?("#{searchInputDir}/#{file}")
            next unless File.file? "#{searchInputDir}/#{file}"
            FileUtils.mv("#{searchInputDir}/#{file}", "/tmp/#{file}")
            lang = 'en' ; lang = $1 if file =~ /[\-\._]([a-zA-Z][a-zA-Z])\./
            system "#{File.dirname(__FILE__)}/ef-find.rb #{db} #{lang} --query-file /tmp/#{file} > #{searchOutputDir}/#{file}-res.tmx.running"
            FileUtils.mv("#{searchOutputDir}/#{file}-res.tmx.running", "#{searchOutputDir}/#{file}-res.tmx")
            File.delete("/tmp/#{file}")
            puts "#{DateTime.now.strftime} - Executed search #{file} language #{lang}"            
        end
    end
end

