require 'elefas'

module Elefas
    
    class ElefasWriter < ElefasClient
        def initialize(dest)
            super(dest)
        end
        
        def start_doc(docName,collection=nil)
            doc_id = nil ; coll_id = nil
            if collection != nil then
                coll_id = @conn.exec("select id from EF_COLLECTION where name=?", collection, Object, 1)
                if coll_id == nil then
                    coll_id = @conn.exec("insert into EF_COLLECTION(name) values(?) returning id", collection, Object, 1)
                    puts "Collection #{collection} created (#{coll_id})"
                else    # if coll already exists also check document
                    doc_id = @conn.exec("select id from EF_DOC where name=:name and collection=:coll", { 'coll' => coll_id, 'name' => docName }, Object, 1)
                end
            else
                doc_id = @conn.exec("select id from EF_DOC where name=:name and collection is null", { 'name' => docName }, Object, 1)
            end
            if doc_id == nil then
                coll_id = 'null' if coll_id == nil
                doc_id = @conn.exec("insert into EF_DOC(name,collection) values (:file,#{coll_id}) returning id", { 'file' => docName }, Object, 1)
                @unitWriter = UnitWriter.new(@conn) unless (defined? @unitWriter and not (@unitWriter.is_a? UnitUpdater))
            else
                @unitWriter = UnitUpdater.new(@conn)  unless (defined? @unitWriter and @unitWriter.is_a? UnitUpdater)
            end
            return doc_id
        end
        
        def write(tu,doc_id)
            # tu_id is unique for a given document
            unit_id = @unitWriter.insertUnit(tu,doc_id)
            # tuv is NOT unique, even for a given language, unless if text is the same
            tu.variants.each { |lang,tuv| @unitWriter.insertSegment(tuv,lang,unit_id) }
        end  
        
        def count_tu() @unitWriter.count_tu() end
        def count_tuv() @unitWriter.count_tuv() end
    end # class ElefasWriter
    
    class UnitWriter
        def initialize(conn)
            @st_ins_unit = conn.prepare('st_ins_unit',
                "insert into ef_unit(tuid,doc_id) values(:tu_id,:doc_id) returning id")
            @st_ins_seg = conn.prepare('st_ins_seg',
                'insert into ef_seg(unit,lang,contents)
                    values(:unit,:lang,:contents)')            
            @count_tu = 0; @count_tuv = 0
        end
        
        attr_reader :count_tu, :count_tuv
        
        # Insert new unit, no check needed
        def insertUnit(tu,doc_id)
            unit_id = nil
            @st_ins_unit.exec({ 'tu_id' => tu.id, 'doc_id' => doc_id }) { |row| unit_id = row["id"] }
            @count_tu = @count_tu + 1
            return unit_id
        end
        
        # Insert segment, no check needed
        def insertSegment(tuv,lang,unit_id)
            @st_ins_seg.exec({ 'unit' => unit_id,  'lang' => lang[0,2], 'contents' => tuv.text })
            @count_tuv = @count_tuv + 1
        end
    end
        
    class UnitUpdater < UnitWriter
        def initialize(conn)
            super(conn)
            @st_sel_unit = conn.prepare('st_sel_unit',
                "select id from ef_unit where tuid = :tuid and doc_id = :doc_id")
            @st_sel_seg = conn.prepare('st_sel_seg',
                "select count(*) count from ef_seg where unit = :unit and lang = :lang and contents=:text")
        end
        
        # Insert new unit only if not exists
        def insertUnit(tu,doc_id)
            unit_id = nil
            @st_sel_unit.exec({ 'tu_id' => tu.id, 'doc_id' => doc_id }) { |row| unit_id = row["id"] }
            if unit_id != nil then return unit_id else return super(tu,doc_id) end
        end
        
        # Insert new segment unless an identical exists
        # tuv is NOT unique, even for a given language, unless if text is the same
        def insertSegment(tuv,lang,unit_id)
            exist = false
            @st_sel_seg.exec({ 'unit' => unit_id, 'lang' => lang[0,2], 'contents' => tuv.text }) { |row| exist = (row['count'].to_i > 0) }
            super(tuv,lang,unit_id) unless exist
        end        
    end
    
end # module Elefas
