###
# A module which makes interface between Postgres and Ruby
# working wih CRuby via Pg, and with JRuby via JDBC

module Musci
   
    def self.alias(name) name.sub!(/^\#/,''); @@aliases = {} unless defined? @@aliases; @@aliases[name] end
    def self.add_aliases(h) @@aliases = {} unless defined? @@aliases; h.each_pair { |k,v| @@aliases[k] = v } end
    
    @@tokenList = []
    
    ##
    # Define whenever tokens are created to limit number of connections
    # If nil (default) we don't use tokens at all
    # If it is a number, we reject (raise exception) if we exceed number of allowed connections
    # Else, must be an hash with two values
    # :action = either reject or wait ; if it is an hash, applied per alias
    # :limits = number of allowed connections ; if it is an hash, applied per alias
    def self.def_token_policy(policy) @@tokenPolicy = policy end
        
    def self.token_connection(dbname, policy = nil, dir = nil, action = nil)
        policy = @@tokenPolicy if policy == nil and defined? @@tokenPolicy
        if policy == nil then 
            return
        elsif policy.is_a? Integer then
            dir = '/tmp/musci-tokens' if dir == nil 
            Dir.mkdir dir unless Dir.exist? dir
            File.open("#{dir}/token-#{$$}-#{dbname}",'w') {}
            @@tokenList = [] unless defined? @@tokenList 
            @@tokenList << "#{dir}/token-#{$$}-#{dbname}"
            if Dir.entries(dir).select { |item| item =~ /^token/ }.count > policy then
                if action == nil then
                    File.delete "#{dir}/token-#{$$}-#{dbname}"
                    raise "Too many connections"
                elsif action == 'reject'
                    File.delete "#{dir}/token-#{$$}-#{dbname}"
                    raise "Too many connections"
                elsif action == 'wait'
                    until Dir.entries(dir).select { |item| item =~ /^token/ }.count <= policy
                        STDERR.puts "Waiting for available connection"
                        sleep 5
                    end
                end
            end
        elsif policy.is_a? Hash then
            action = policy['action']; limits = policy['limits']
            if action.is_a? Hash then
                if action[dbname] != nil then action = action[dbname] else action = action['default'] end
            end
            if limits.is_a? Hash then
                if limits[dbname] != nil then 
                    limits = limits[dbname] 
                    dir = "/tmp/musci-tokens/#{dbname}"
                else 
                    limits = limits['default'] 
                    dir = "/tmp/musci-tokens/default"
                end
            end
            Musci::token_connection(dbname, limits, dir, action)
        end
    end
    
    def self.free_connection(dbname) @@tokenList.each { |item| File.delete(item) if item =~ /token-#{$$}-#{dbname}/ } end
        
    # Free all connections if the process stops without closing them properly
    END { @@tokenList.each { |item| File.delete(item) if File.exists? item } }

    if RUBY_PLATFORM == 'java' then
        require 'musci/java'
    elsif RUBY_ENGINE == 'ironruby'
        # Later
    else
        require 'musci/pg'
    end

    
end
