---------------- List of tables for Elefas memory
--- Usage: psql [database] < sql/tables.sql
--- Must be ran by a Postgres user which has creation permissions for given catalog

create table EF_COLLECTION(
	id serial not null primary key,
	name varchar(64) not null unique
);

create table EF_DOC(
	id serial not null primary key,
	name varchar(200) not null,
	collection int null references EF_COLLECTION(id),
	constraint UDOC unique(name,collection)
);

-- Table for a unit (TMX:tu; groups a segment in different languages)
create table EF_UNIT(
	id serial not null primary key,
	tuid VARCHAR(200) null	,	-- as in a TMX file
	doc_id int not null references ef_doc(id),
	constraint UUNIT unique(tuid, doc_id)	
);


-- Table for a segment for a given language
create table EF_SEG(
	id serial not null primary key,
	unit int not null references EF_UNIT(id),
	lang char(2) not null,
	contents TEXT

);


-- LICENCE
--
--  Copyright 2013,2016 Silvestris Project (http://www.silvestris-lab.org/)
--
--  Licensed under the EUPL, Version 1.1 or â€“ as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
--  You may not use this work except in compliance with the Licence.
--  You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl
--
--  Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the Licence for the specific language governing permissions and limitations under the Licence. 
