DESCRIPTION
===========

Spongiae is a set of Ruby classes to read various file formats and produce something usable by Computer Assisted Translation tools. 

USAGE:
======

This is a library to be used inside Ruby programs.
See bin/sg_toXliff.rb for example of usage.

sg_toXliff.rb extracts contents from input file to an XLIFF. 
Syntax: sg_toXliff.rb [input file]
Will produce [input file].xlf

By default each entry from the file is extracted to one unit (<trans-unit> with <source> only)
If you want to activate segmentation (producing <seg-source>) you must have Culter installed in lib/ directory
Syntax: sg_toXliff.rb [--seg file.srx] [--src-lang lg] [input file]
For a very simple segmentation (with only dots) use --seg simple
For SRX segmentation, if you don't specify a language the tool will do as if language was 'x-unknown'

sg_fromXliff.rb takes an XLIFF and the original file to build the native target (translated) file
Syntax: sg_fromXliff.rb [xliff file] [native input] [native output]

Supported formats:
- plain text
- Java properties
- Gettext's PO file
- Android strings
- Docbook (without tags for the moment)
- HTML (without tags for the moment)
- OpenDocument (without tags for the moment)
- OpenXML (read-only and without tags for the moment)

sg_mergeToTmx.rb can take the xliff files for various language variants of the same source file and produce a TMX
Syntax: sg_mergeToTmx.rb [source language] [target language 1:/path/to/file1] [target language 2:/path/to/file2]+

sg_stats.rb gives you statistics about a document (number of words, characters, etc)
Supports all formats mentioned in the list two paragraphs before

LICENSE:
========

Please read the file LICENSE for the very last version of conditions applied to this code.

