#! /usr/bin/env ruby 

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'spongiae/tmx'


unless ARGV.count >= 2
    puts "Spongiae #{Spongiae::VERSION}"
    puts "Syntax: sg_splitTmx.rb <tmx file> <source lang>"
    exit
end

handles = {}    # files per lang
iniFile = ARGV.shift
srcLang = ARGV.shift

Spongiae::TMX::TmxReader.new(iniFile).read_unit do |tu|
   tu.split(srcLang) do |traLang,part|
       unless handles.key? traLang
           destFile = iniFile.gsub(/\.tmx$/, "-#{traLang}.tmx")
           handles[traLang] = File.open(destFile, "w:UTF-8")
           handles[traLang] = Spongiae::TMX::TmxWriter.new(handles[traLang])
       end
       handles[traLang].add(tu.id,part)
   end
end

handles.each { |k,v| v.close }
