require 'spongiae/util/xml_callbacks'
require 'spongiae/unit'
require 'spongiae/tags'

require 'anguilla/zip'

module Spongiae
   module Formats
       
       class OpenDocCallbacks
           include REXML::StreamListener
           
           def initialize(sub)
               @sub = sub; @id = 0; @text = ''
               @paraStack = []
           end
           
           include Spongiae::Util::XmlCallbacks::InputCallback
           
           def is_para_start?(name, attrs = nil)  name =~ /^text:(p|h)$/ end
  
           def tag_start(name, attrs)
               if name =~ /note/ and @foundNotes == nil then
                   puts "Warning: document contains notes, which are not yet supported"
                   @foundNotes = true
               end
                @id = @id + 1 if name =~ /^text:(p|h)$/
               check_para_start(name,attrs) 
           end
           
           def tag_end(name)
               if name =~ /^text:(p|h)$/ then 
                   @sub.call Spongiae::Unit::Unilingual.new(@file, @id.to_s, nil, Spongiae::Tags::TaggedString.new(@text,@tags)) unless @text == nil or @text == ''
                   if @paraStack.count > 0 then
                       tmp = @paraStack.pop
                       @text = tmp[0]; @tags = tmp[1]; @tagStack = tmp[2]
                       return
                   else
                       @text = ''; @tags = []; @tagStack = []
                       @inPara = false
                   end
               end
               pop_para_end_tag(name)
           end
       end
       
       class OpenDocCallbacksOutput <  OpenDocCallbacks
           def initialize(dest,sub)
               super(sub); @dest = dest
           end
           
           include Spongiae::Util::XmlCallbacks::OutputCallback           
           
           def tag_start(name, attrs)
               super(name, attrs)
               print_para_start(name,attrs)
           end
           
           def tag_end(name)
               super(name)
               print_para_end(name) unless name =~ /note/
           end
           
           def text(text) 
               if @inPara then 
                   @text = @text + text 
               else
                   @dest.print text
               end
           end
       end
       
       
       class OpenDocFile
           
           def initialize(file, props = {})
               @file = file
           end
           
           # read_strings : build unit for each string
           # For Plain Text, this is one string per line.
           def read_unit(&sub)
               Anguilla::Zip.browsingZip(@file) do |entry|
                    if entry.name =~ /content\.xml/ then                       
                        callback = OpenDocCallbacks.new(sub)
                        Anguilla::Zip.parse(entry.get_input_stream,callback)
                    end
               end
           end
           
           def translate(dest_file_name,translations_map,props={})
               Zip::OutputStream.open(dest_file_name) do |outs|
                   Anguilla::Zip.browsingZip(@file) do |entry|
                        outs.put_next_entry entry.name
                        if entry.name =~ /content\.xml/ then
                            callback = Spongiae::Util::XmlCallbacks::OutputCallback.translation_proc(translations_map,outs)
                           callback = OpenDocCallbacksOutput.new(outs, callback)
                           Anguilla::Zip.parse(entry.get_input_stream,callback)
                        else
                            outs.copy_raw_entry entry                            
                        end
                   end
               end                   
           end
           
       end
       
   end
end
