require 'spongiae/unit'
require 'spongiae/xliff'

require 'anguilla'

module Spongiae
   module Formats
       
       class XliffFilter
           def initialize(file, props = {})
               @file = file
           end
           
           # read_strings : build unit for each string
           def read_unit(&sub)
               callback = Spongiae::XLIFF::Xliff_Callback.new(sub)
               Anguilla::parse(@file,callback)
           end
           
           def translate(dest_file_name,translations_map,props={})
              File.open(dest_file_name, 'w:UTF-8') do |dest|
                  writer = Spongiae::XLIFF::XliffWriter.create(dest, @file, props, nil, translations_map)
                  read_unit { |unit| writer.write_unit(unit) }
                  writer.close    
              end
           end
       end
       
   end
end
