#! /usr/bin/env ruby 

formatOptions = {}
ARGV.each { |item| formatOptions[$1] = $2 if item =~ /^--fmt:([\w\-]+)=(.+)$/ }
ARGV.reject! { |item| item =~ /^--fmt:([\w\-]+)=(.+)$/ }

if ARGV.count < 1
    puts "Syntax: #{__FILE__} [--fmt:option=value]{0,*} <native original>"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

require 'getoptlong'


options = {}
GetoptLong.new(
  [ '--seg', '-s', GetoptLong::REQUIRED_ARGUMENT ],
  [ '--src-lang', '--srcLang', '-o', GetoptLong::OPTIONAL_ARGUMENT ],
  [ '--tra-lang', '--traLang', '-t', GetoptLong::OPTIONAL_ARGUMENT ],
  [ '--version', '-v', GetoptLong::OPTIONAL_ARGUMENT ],
).each { |key,val| options[key] = val }

culter = nil
# Load culter module only if required. So, Culter is not mandatory to use Spongiae
if options['--seg'] =~ /^simple$/ then
    require 'culter/simple'; culter = Culter::Simple.create(keeps_spaces: true)
elsif options['--seg']  =~ /\.srx$/ then
    require 'culter/srx'
    culter = Culter::SRX::SrxDocument.new(options['--seg'])
    if options['--src-lang'] != nil then
        culter = culter.segmenter(options['--src-lang'])
    else
        culter = culter.segmenter('x-unknown')
        puts "SRX found, but missing source language, segmentation will be based on common rules"
    end
end


file = ARGV.shift

require 'spongiae/formats/all'
unless "".respond_to? :to_xliff     # if tags are not loaded
    class String
        def to_xliff(segmented = true) encode(:xml => :text) end
    end
end

ext = $1 if file =~ /\.(\w+)$/
fmt = Spongiae::Formats::ALL[ext].sniff(file)
fmt.load!
if (culter != nil) and (ext =~ /docx/i) then formatOptions['tags'] = "false"; puts "Temporarily inactivate tags because of segmentation" end
reader = fmt.create(file,formatOptions)

require 'spongiae/xliff'

dest = file.gsub(/\.(\w+)$/) { options['--tra-lang'] == nil ? ".#{$1}.xlf" : "-#{options['--tra-lang']}.#{$1}.xlf" }
if File.exists? dest then
    puts "Overwrite #{dest}, keeping translations"
    translations_map = Spongiae::XLIFF::read_translations_map(dest)
    puts "#{translations_map.count} translations found"
else
    puts "Writing #{dest}"
    translations_map = Hash.new # empty, but must not be nil
end

File.open(dest, "w:UTF-8") do |f|
    writer = Spongiae::XLIFF::XliffWriter.create(f, file,options, culter, translations_map)
    reader.read_unit { |unit| writer.write_unit(unit) }
    writer.close    
end
