if RUBY_PLATFORM == 'java' then
  require 'exilis_jruby'
elsif RUBY_ENGINE == 'ironruby'
  require 'exilis_iron'
end

module Exilis

	def readStopWords(f)
		stopWordsKeys = {}
                return stopWordsKeys unless File.exist? f
		File.open(f,'r:UCS2-LE') do |outf|
			while line = outf.gets
				if line =~ /^\[(.+)\]/
					key = $1
					stopWordsKeys[key] = Array.new
				else
					line.chomp!
					stopWordsKeys[key] << line
				end
			end
		end
		return stopWordsKeys
	end
	module_function :readStopWords
    
	class NgramParser
		def initialize()
			@stop = Hash.new
		end
		
		attr_writer :stop
        
        def languages() @stop.keys.map { |item| $1 if item =~ /^(.+?)\./ }.uniq end
	end
	
	class ExilisWriter
		attr_reader :count
	end
    
	class ExilisExplorer        
		def entryById(id,targets=nil)
			return toEntry(@reader.document(id),id,targets)
		end
	end
    
    class ExilisSearcher < ExilisExplorer
        def languages()
            if @analyzer.respond_to? :languages then
                res = @analyzer.languages
                return res if res.count > 0
            end
            return super.languages  # in lang-specific
        end
    end

end

