#! /usr/bin/env jruby 

if ARGV.count < 4
    puts "Syntax: "
    puts "\t#{__FILE__} <exilis directoy> <lang> -phrase <phrase>"
    puts "\t#{__FILE__} <exilis directoy> <lang> -file <file> [-seg simple|rules.srx]"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
require 'exilis'

searcher = Exilis::ExilisSearcher.new ARGV[0]

require 'spongiae/tmx'
writer = Spongiae::TMX::TmxWriter.new(STDOUT)

if ARGV[2] =~ /phrase/ then
    count = 0
    searcher.fuzzySearch(ARGV[3],ARGV[1],30,300) do |tu|
        writer.add tu.id, tu
        count = count + 1
    end
    writer.comment "#{count} segments found"
elsif ARGV[2] =~ /file/ then
    require 'set'; found = Set.new
    require 'spongiae/formats/all'
    file = ARGV[3]
    ext = $1 if file =~ /\.(\w+)$/
    fmt = Spongiae::Formats::ALL[ext].sniff(file)
    if fmt == nil then
        puts "Format #{ext} is not yet supported"
        exit
    end
    fmt.load!
    if ARGV[4] =~ /-s/ then
        if ARGV[5] =~ /^simple$/ then
            require 'culter/simple'; culter = Culter::Simple.new
        else
            require 'culter/srx'
            culter = Culter::SRX::SrxDocument.new(ARGV[5]).segmenter(ARGV[1])
        end
    else
        class EmptyCulter
            def initialize() @t = Array.new end
            def cut(phrase) 
                @t[0] = phrase; return @t 
            end
        end
        culter = EmptyCulter.new
    end
    reader = fmt.create(file)    
    reader.read_unit do |fileUnit|       
        next unless fileUnit.srcText =~ /\w/
        culter.cut(fileUnit.srcText).each do |phrase|
            writer.comment "Searching #{phrase}"
            searcher.fuzzySearch(fileUnit.srcText,ARGV[1],30,5) do |tu|
                next if found.member? tu.id
                writer.add tu.id, tu
                found << tu.id
            end
        end
    end
    writer.comment "#{found.count} segments found"
else
    puts "Must specify query mode [file or phrase]"
    exit
end
    

writer.close
