#! /usr/bin/env jruby

if ARGV.count < 1
    puts "Syntax: #{__FILE__} <database directoy>"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

require 'exilis'
require 'spongiae/unit'

searcher = Exilis::ExilisExplorer.new ARGV[0]

puts "unit(s): #{searcher.count}"
docs = {}
searcher.findAll([]) { |tu| docs[tu.props['file']] = 1 if tu.props['file'] != nil }
puts "document(s): #{docs.count}"
if ARGV.count > 1 and ARGV[1] =~ /-l/ then
    puts "languages: #{searcher.languages.count} (#{searcher.languages.join(',')})"
else
    puts "languages: #{searcher.languages.count}"
end
