require 'sinatra'

require './config'	# loads config.rb

require "dbm"


helpers do
    $auths = Hash.new    # key = host name, value = one DBM file
    
    def protected!
        tab = authorized?
        if tab == false then
            headers['WWW-Authenticate'] = 'Basic realm="Restricted Area"'
            halt 401, "Not authorized\n"
        elsif tab[1] =~ /^\d+$/ or tab[1] == "123456".crypt('silvestris/consociata')
            unless request.env['PATH_INFO'] =~ /user/   
                redirect '/user' # force to change pasword immediately
            else
                return tab
            end
        else
            return tab
        end
    end

    def authorized?
        @auth ||=  Rack::Auth::Basic::Request.new(request.env)
        if @auth.provided? and @auth.basic? and @auth.credentials then
            auth_db = $auths[request.env['HTTP_HOST']]
            if auth_db == nil then
                filename = settings.auth.gsub(/\$HOST\[(\d+)\]/) { num = $1.to_i; request.env['HTTP_HOST'].split(/\./)[num - 1] }
                puts "Opening auth file #{filename}"
                if filename != settings.auth then
                    auth_db = $auths[request.env['HTTP_HOST']] ||= DBM.open(filename, 0666, DBM::WRCREAT) 
                else
                    auth_db = $auths['DEFAULT'] ||= DBM.open(filename, 0666, DBM::WRCREAT) if auth_db == nil                        
                end
            end
            req_user = @auth.credentials[0]; req_pass = @auth.credentials[1]                
            db_info = auth_db[req_user]
            if (db_info == nil) or (db_info.length == 0) then
                false
            else
                umail, current_user_rights, db_pass = db_info.split(/\#\#\#/)
                current_user_rights = req_user + '###' + current_user_rights
                if req_pass.crypt('silvestris/consociata') === db_pass then
                    return current_user_rights, db_pass, umail
                else
                    return false
                end
            end
        else
            false
        end
    end
end

def users_count
    auth_db = $auths[request.env['HTTP_HOST']]
    return auth_db.keys.count        
end

def add_user(login,email,roles)
    host = request.env['REQUEST_URI'].gsub(/\/admin.+$/,'')
    puts "./set-user.rb #{host} #{login} #{email} #{roles}"
    system './set-user.rb', host, login,email,roles
end

get '/admin/users/add' do
    roles = ''
    ['admin','search','upload'].each do |item|
        roles << item + ',' if 'on' == params[item]
    end
    roles.gsub!(/,$/,'')
    if $auths[request.env['HTTP_HOST']].key? params['login'] then
        main_admin_page("User #{params['login']} already exists", 'ERROR')
    elsif params['login'].length == 0 then
        main_admin_page("Please give a login for the new user", 'ERROR')
    elsif roles.length == 0 then
        main_admin_page("Please give almost one role to the new user", 'ERROR')
    elsif params['mail'].length == 0 then
        main_admin_page("Please give an email, else the user will not be informed", 'ERROR')
    else
        add_user(params['login'], params['mail'], roles)
        $auths[request.env['HTTP_HOST']].close; $auths[request.env['HTTP_HOST']] = nil; authorized?  # force reload
        main_admin_page("User #{params['login']} sucessfully added", 'INFO')
    end
end

post '/admin/users/add' do
    unless params[:file] && (tmpfile = params[:file][:tempfile]) && (name = params[:file][:filename])
        halt "No file selected"
    end        
    count = 0; lid = 0; err = Array.new
    while (line = tmpfile.gets) != nil
        tab = line.split(/\t/); lid = lid + 1
        if tab.count < 3 then
            err << "Line #{lid} : missing fields (#{tab.count})" unless tab[0] =~ /^\s*$/
        elsif $auths[request.env['HTTP_HOST']].key? tab[0] then
            err << "Line #{lid} : user #{tab[0]} already exists"
        else
            roles = ''
            ['admin','search','upload'].each do |item|
                roles << item + ',' if tab.any? { |col| col =~ /#{item}/ }
            end
            if roles.length == 0 then
                err << "Line #{lid} : missing roles"
            else
                add_user(tab[0], tab[1], roles)
            end
        end
    end
    if err.count == 0 then
        main_admin_page("#{count} users added", 'INFO')
    elsif count > 0 then
        main_admin_page("#{count} users added <br> " + err.join('<br>'), 'WARNING')
    else 
        main_admin_page(err.join('<br>'), 'ERROR')
    end
end

get '/admin/users/list' do
    auth_db = $auths[request.env['HTTP_HOST']]
    start = 0; start = params['start'] if params.key? 'start'
    erb  :users_list, :locals => { :auths => auth_db, :start => start }
end


get '/user' do 
    current_user_rights, db_pass = authorized? 
    command_res = nil
    command_res = 'You must change your password immediately' if db_pass =~ /^\d+$/ or db_pass == "123456".crypt('silvestris/consociata')
    req_user, db_info = current_user_rights.split(/\#\#\#/)
    locals = { :req_user => req_user, :command_res => command_res }
    locals[:msg_status] = 'ERROR'
    erb :user, :locals => locals
end
post '/user/change-pass' do
    current_user_rights, db_pass = protected! 
    req_user, rights = current_user_rights.split(/\#\#\#/)
    locals = { :req_user => req_user }
    if params[:actual].crypt('silvestris/consociata') != db_pass then
         locals[:command_res] = 'ERROR : incorrect actual password'
         locals[:msg_status] = 'ERROR'
    elsif params[:new_one] != params[:new_two] then
         locals[:command_res] = 'ERROR : new password fields differ'
         locals[:msg_status] = 'ERROR'
    else
         auth_db = $auths[request.env['HTTP_HOST']]
         db_info = auth_db[req_user].split(/\#\#\#/)
         auth_db[req_user] = db_info[0] + '###' + db_info[1] + '###' + params[:new_one].crypt('silvestris/consociata')
         locals[:command_res] = 'OK, password changed'
         locals[:msg_status] = 'OK'
    end
    erb :user, :locals =>  locals
end    
