# Configuration file for Consociata, to be modified before you start the application
# See documentation of Ruby/Sinatra for syntax of this file: http://sinatrarb.com/intro.html

configure do 
   # Name to be displayed in the template. You should indicate here whenever you use Elefas or Exilis, or you may use your own internal name
   set :app_name, 'Elefas Translation Memory Manager'
   
   # Define that the application requires authentication (if not, comment this line)
   # Contains the name of a DBM file which will memorize users, crypted passwords. Supports multi-hosts
   set :auth, 'users-$HOST[1]'
   
   # Text which will appear in the main window, used to make announements
   # set :announce, 'This is a <b>sample</b> config file, don\'t forget to adapt it to your needs'
   # Different value per host
   set :announce, {
       :choice => '$HOST[1]',
       'default' => 'This is a <b>sample</b> config file, don\'t forget to adapt it to your needs',
       'test-elefas' => 'You are connected to Test elefas memory',
       'sample2' => 'file:../sample2-test.html',
       'sample3' => 'file:../sample3-test.txt',       
   }
   
   # help file
   set :help, {
       :choice => '$HOST[1]',
       'default' => 'help/elefas.html',   
   }   
   
   # List of supported formats for input files
   # Should be taken from Spongiae, this will be changed later
   set :input_formats, [ 'HTML','Java properties','Docbook','Microsoft Open XML','LibreOffice Open Document' ]
   
   # Path to either Exilis or Elefas. Points to top directory, not to bin
   set :exe_dir, '../Elefas-Maximus'
   
   # Whenever we are using Elefas or Exilis. actually not possible to use both in same web interface.
   set :app_type, 'Elefas'
   
   # Database. Here in Elefas syntax
   # set :database, 'test-elefas:test-elefas:test'
   # With a variable replaced by host name. Warning: do not use " " or Ruby variables, this must be interpreted after reading this file!
   set :database, '$HOST[1]:$HOST[1]:test'
   
   # Which file is used for segmentation. Can use an hash instead
   set :segmentation, '$HOST[1].srx'
   
   # Can disable statistics if they took too much time
   set :always_recalc_stats, true
   
   # Elefas is not optimized for interactive use. It will work but can decrease performances
   set :allow_small_search, true
   
   # Up to 20K, upload synchronously. Else, reply immediately and load in background
   set :limit_sync_upload => 20_000
   
   # Allow search from file to file
   set :dest_dir => '/tmp'
   
   # Since user may not have access to server, send mail instead
   set :send_mail => {
        :from => 'Consociata@silvestris-lab.org',
       :smtp => 'localhost'
    }
   
   # Where to put logs - only without deamon
   set :proc_logs => {
      :location => '/tmp/consociata/logs',
      :by_db => true,  # in case of multi-host, true means display only the processes for current database, false means display all
   }
   
   
   # Statistics about document (optional, may slow down the app)
   set :doc_stats => {
       :exe =>    '/home/debian/Ruber-dev/Spongiae/bin/sg_stats.rb',
       #    :details => false,              # Display only number of units (default)
       :details => ' <br> ',                # Display all details, one per line (separator is in HTML)
       # :details => ' ; ',                  # Display all details in one single line
   }
   
   # ------------------------ Deamon usage (Elefas only)
   
   set :deamon => {
       :must_start => true, # if not, the deamon is supposed to be already running
       :import_dir => '/home/debian/Ruber-dev/deamon/import',
       :search_input => '/home/debian/Ruber-dev/deamon/search-in',
       :search_result => '/home/debian/Ruber-dev/deamon/search-res',       
    }
   
   # If database is divided in collections
   set :collections => [    'Collection 1', 'Collection 2'  ]
   
   
end 
