if defined? settings.send_mail then
    require 'net/smtp' 
    require 'mail'
    require 'zip'
    
    def sendFileByMail(file) 
         Thread.new {
              sleep(5) until File.exists? file
              zip_file = Tempfile.new("example.zip")
              shortName = file.sub /^.+\//, ''
              Zip::File.open(zip_file.path, Zip::File::CREATE) do |zipfile|
                 zipfile.add(shortName, file)
              end
              file = zip_file
              filecontent = File.read(file)
              zip_file.unlink
              shortName = shortName + '.zip'
              msg_from = settings.send_mail[:from]; msg_to = params[:email]
                message = Mail.new do
                    from msg_from
                    to msg_to
                    subject 'Result of your search'
                    body 'Here is the result of your search'
                    add_file :filename => shortName, :content => filecontent
                end
                smtp = settings.send_mail[:smtp]
                Mail.defaults do
                    delivery_method :smtp, address: smtp #, port: 1025
                end
                message.deliver
         }
    end
end

def action_file_search!(name,file)
    msg = "Analysis of #{name} started"; warn_msg = err_msg = nil
  if defined? settings.deamon then
      name.sub!(/\.(\w+)$/) { |ext| "-#{params['src']}#{ext}" } unless name =~ /[\-\.\_]#{params['src']}.\w+$/
      if params[:collection] != nil then
          FileUtils.cp(file.path, "#{settings.deamon[:search_input]}/coll-#{params[:collection]}/#{name}")      
      else
          FileUtils.cp(file.path, "#{settings.deamon[:search_input]}/#{name}")
      end
      if defined? settings.send_mail and defined? params[:email] then
          sendFileByMail("#{settings.deamon[:search_result]}/#{name}-res.tmx")
          res = "Result will be sent by mail to #{params[:email]}"
      else
           res = "Result will be in file #{settings.deamon[:search_result]}/#{name}-res.tmx"
      end      
  else
      begin
          File.delete "#{settings.dest_dir}/#{name}-res.tmx"
      rescue Errno::ENOENT
          # File does not exist: ok we can create it
      rescue Errno::EACCES
          # Cannot delete, so let's avoid to return a wrong file!
          err_msg = "Problem accessing internal file"
          return msg, '', warn_msg, err_msg
      end
      host = request.env['SERVER_NAME'].split(/\./)
      db = settings.database.gsub(/\$HOST\[(\d+)\]/) { num = $1.to_i; host[num - 1] }
        if defined? settings.segmentation then
            if settings.segmentation.is_a? Hash then
                segfile = settings.segmentation[db]
            else
                segfile = settings.segmentation.dup
                segfile.gsub!(/\$HOST\[(\d+)\]/) { num = $1.to_i; host[num - 1] }
            end
            if not File.exists? segfile then
                warn_msg = "Segmentation file #{segfile} not found"
                segfile = nil # do not use it
            end
        else
            segfile = nil
        end
        lang = params['src']; lang = lang + ":#{params['tra']}" if params['tra']
        if settings.app_type =~ /f/ then 
            collection = "--collection #{params[:collection]}" unless params[:collection] == nil or params[:collection] == ''
            exe_name = "#{settings.exe_dir}/bin/ef-find.rb #{db} #{lang} #{collection} --query-file #{file.path}"
            exe_name = exe_name + " --segmenter #{segfile}" unless segfile == nil
            exe_name = exe_name + " --output-file '#{settings.dest_dir}/#{name}-res.tmx'"
        elsif settings.app_type =~ /x/ then
            exe_name = "#{settings.exe_dir}/bin/ex-find.rb #{db} #{lang} -file #{file.path}"
            exe_name = exe_name + " -s #{segfile}" unless segfile == nil
            exe_name + " > '#{settings.dest_dir}/#{name}-res.tmx'"
        else
            halt 'Must configure Elefas or Exilis (parameter "app_type")'
        end       
        if defined? settings.proc_logs then exe_name = exe_name + " 2>> '#{settings.proc_logs[:location]}/#{name}.log'" else exe_name = exe_name + " 2> /dev/null" end
       pid = fork { exec exe_name }
       $cs_proc_ids[pid] = [ 'Search', name, Time.now, request.env['REMOTE_USER'], cur_database(request,true) ]  if defined? settings.proc_logs
      if defined? settings.send_mail and defined? params[:email] then
          sendFileByMail("#{settings.dest_dir}/#{name}-res.tmx")
          res = "Result will be sent by mail to #{params[:email]}"
      else
           res = "Result will be in file #{settings.dest_dir}/#{name}-res.tmx"
      end
  end    
  if defined? settings.doc_stats then
      dstats = `#{settings.doc_stats[:exe]} #{file.path}`
      $cs_proc_ids[pid][5] = $1 if dstats =~ /(\d+)\s*\n/
      if defined? settings.doc_stats[:details] and settings.doc_stats[:details].is_a? String then 
          msg = msg + " <br> " + dstats.gsub(/\n/, " #{settings.doc_stats[:details]}\n")
      else
          msg = msg + " <br> " + dstats.gsub(/\n.+$/, '')
      end
  end  
  return msg, res, warn_msg, err_msg
end

# Analyses the uploaded file and puts result in a temporary folder

post '/file-search' do
    current_user_rights = protected! 
  unless params[:file] && (tmpfile = params[:file][:tempfile]) && (name = params[:file][:filename])
      halt "No file selected"
  end  
  
  msg, res, warn_msg, err_msg = action_file_search!(name,tmpfile)
  locals = { :stats => stats(request), :umail => current_user_rights[2] }
  if err_msg != nil then
      locals[:msg_status] = 'ERROR'; locals[:command_res] = err_msg
  elsif warn_msg != nil then
      locals[:msg_status] = 'INFO'; locals[:command_res] = "#{msg}<br/>#{res}<br/><font color=Orange>Warning:</font> #{warn_msg}"
  else
      locals[:msg_status] = 'INFO'; locals[:command_res] = "#{msg}<br/>#{res}"
  end
  locals[:db] = cur_database(request,true) if settings.database =~ /\$/
        
  erb :home, :locals => locals  
end

get '/api/batch-search' do
    protected!
    return '{ "result": "error", "cause": "Language missing" }' unless params['src']
    return '{ "result": "error", "cause": "File not found" }' unless File.exist? params[:file]
    
    msg, res, warn_msg, err_msg = action_file_search!(name,params[:file])
  if err_msg != nil then
        return <<EOF
{ "result": "ERROR", "message": "#{err_msg}" }        
EOF
  elsif warn_msg != nil then
        return <<EOF
{ "result": "OK", "message": "#{msg} -- #{res} -- #{warn_msg}" }        
EOF
  else
        return <<EOF
{ "result": "OK", "message": "#{msg} -- #{res}" }        
EOF
  end    
end

post '/api/batch-search' do
    protected!
    return '{ "result": "error", "cause": "Language missing" }' unless params['src']
    return '{ "result": "error", "cause": "File name missing" }' unless params[:file]

    ext = $1 if params[:file] =~ /(\.\w+)$/
    tmpFile = Tempfile.new(['upload',ext])
    tmpFile.write request.body.read
    
    msg, res, warn_msg, err_msg = action_file_search!(params[:file],params[:file])
  if err_msg != nil then
        return <<EOF
{ "result": "ERROR", "message": "#{err_msg}" }        
EOF
  elsif warn_msg != nil then
        return <<EOF
{ "result": "OK", "message": "#{msg} -- #{res} -- #{warn_msg}" }        
EOF
  else
        return <<EOF
{ "result": "OK", "message": "#{msg} -- #{res}" }        
EOF
  end    
end
