module Spongiae
   module Formats
       
       class Selector
           attr_reader :module, :class
           
           def initialize(mod,cls)
               @module = mod; @class = cls
           end
           
           def load! 
               require "spongiae/formats/#{@module}" 
           end
           
           def create(file,props = {})
               "Spongiae::Formats::#{@class}".split('::').inject(Object) {|o,c| o.const_get c}.new(file,props)
           end
           
           def sniff(file)
               self
           end
       end
       
       class XmlSniffer
           def sniff(file)
               File.open(file, "r:UTF-8") do |f|
                   while line = f.gets
                       return Selector.new('android', 'AndroidStrings') if line =~ /<resources/
                       return Selector.new('docbook', 'Docbook') if line =~ /<!DOCTYPE/ and line =~ /DocBook/
                   end
               end
           end
       end
       
       ALL = {
            'txt' => Selector.new('text','PlainText'),
           'properties' => Selector.new('java_properties', 'JavaProperties'),
           'po' => Selector.new('gettext', 'GettextPo'),
           'srt' => Selector.new('srt', 'Srt'),
           'html' => Selector.new('html', 'HtmlDocument'),
           'odt' => Selector.new('opendoc', 'OpenDocFile'),
           'odp' => Selector.new('opendoc', 'OpenDocFile'),
           'ods' => Selector.new('opendoc', 'OpenDocFile'),
           'docx' => Selector.new('openxml', 'OpenXmlFile'),
           'xml' => XmlSniffer.new
        }
       
   end
end
