%Elefas::Config = (

    # Aliases to already existing databases
    # any command with database prefixed by # will be replaced by this value
    # Example:  ef-import.pl '#test' test.tmx
    databases => {
        'test' => 'DBI:Pg:dbname=sample;username=xxx;password=xxx'
    },

    # Configure search
    # Actually we can only configure limit, i.e. how many results are retrieved per segment
    search => {
        string => {
            limit => 50
        },
        file => {
            limit => 5
        }
    },
    
    # Converters: for non-XLIFF formats, enable to call your favorite converter before the search
    # Option 1: same converter everywhere
    converters => {
        # sample with Spongiae
        command => 'sg_toXliff.rb $file',
        out_file => '$file.xlf',
        # after => 'rm $file'       # executed after the file is fully parsed
        after => 'perl:unlink'      # equivalent to rm $file using perl's unlink function
        # sample with Tikal (okapi tools)
        # command => 'sh tikal.sh -x $file',
        # sample with OpenXliff (https://github.com/rmraya/OpenXLIFF)
        # command => 'sh convert.sh -file $file -srcLang $lang'
    }
    # Option 2 : per file format
    converters => {
        odt => { command => 'sg_toXliff.rb $file', out_file => '$file.xlf' },
        docx => { command => 'sg_toXliff.rb $file', out_file => '$file.xlf' }
    }
);
