/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2013-2017 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.glos;

import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;

import java.util.*;

public class HttpGlossary extends HttpCyclotis<GlossaryEntry> implements IWritableGlossary {
	
	protected static final String LINE_FORMAT = "otn";

	private boolean priority = false;
	
	public HttpGlossary (Properties propList) {
		super (propList);
		priority = "true".equals(propList.getProperty("##PriorityGlossary##"));
	}
	
	/* -------------------- HttpCyclotis ---------------- */
	
	@Override
	public final GlossaryEntry analyzeLine (HttpOutputFormat fmt, Object args) {
		return fmt.buildGlossaryEntry(this, args, priority);
	}
	
	/* ------------------ IWritableGlossary --------------------- */
	
	public void addEntry(Language sLang, Language tLang, GlossaryEntry entry) throws Exception {
		registerTranslation (entry);
	}
	
	protected Map<String,String> encodeArgs (GlossaryEntry entry)  {
		Map<String, String> args = new HashMap<String,String> ();
		args.put("src", reformatText(entry.getSrcText(),false));
		args.put("tra", reformatText(entry.getCommentText(),false));
		args.put ("note", entry.getCommentText());	
		return args;
	}	
	
	/* ------------------ IGlossary --------------------- */
	
	public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
		logMessage("search", "Searching for '" + srcText + "'");
		return (List<GlossaryEntry>) httpGetAll("glosSrc", HttpGlossary.LINE_FORMAT + "&langSrc=" + sLang.getLanguageCode(), srcText);
	}

	/* ------------  Logging -------------- */
	
	public StringBuffer entryToLogString (GlossaryEntry entry, boolean detailed, boolean digest) {
		StringBuffer buf;
		buf = new StringBuffer("\t<Glossary Entry>\n");
		if (!digest) {
			buf.append ("\t\t<source>" + entry.getSrcText() + "</source>\n");		
			buf.append ("\t\t<target>" + entry.getLocText() + "</target>\n");
		} else {
			buf.append ("\t\t<source digest='" + digest(entry.getSrcText()) + "'>" + entry.getSrcText() + "</source>\n");		
			buf.append ("\t\t<target digest='" + digest(entry.getLocText()) + "'>" + entry.getLocText() + "</target>\n");			
		}
		buf.append ("\t</Glossary Entry>");
		return buf;
	}
	
}
