/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2015-2017 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.http;

import org.silvestrislab.cyclotis.omegat.HttpCyclotis;

import java.io.InputStream;
import java.util.List;
import java.util.Iterator;

public interface HttpOutputFormat {
	public String MIME();

	public <T> List<T> readFromGet (HttpCyclotis<T> cyclotis, InputStream is, String encoding) throws Exception;
	public <T> Iterator<T> iterator (final HttpCyclotis<T> cyclotis, final InputStream is, final String encoding);

	public org.omegat.core.data.PrepareTMXEntry buildTmxEntry (org.silvestrislab.cyclotis.omegat.tm.HttpMemory memory, Object args);
	public org.omegat.core.matching.external.ProjectMemory.ContextTMXEntry buildContextEntry (org.silvestrislab.cyclotis.omegat.proj.HttpProjectMemory memory, Object args);
	public org.omegat.gui.glossary.GlossaryEntry buildGlossaryEntry (org.silvestrislab.cyclotis.omegat.Cyclotis memory, Object args, boolean priority);
}
