/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2013-2015 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.proj;

import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.ProjectMemory.ContextTMXEntry;
import org.omegat.core.data.TMXEntry.ExternalLinked;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.Core;
import org.omegat.util.Language;
import org.omegat.util.WikiGet;
import org.omegat.util.TMXProp;

import java.io.*;
import java.net.*;
import java.util.*;

public class HttpProjectMemory extends HttpCyclotisTMX<ContextTMXEntry> implements ProjectMemory.IConvertibleExternalProjectMemory {
	public static final int COL_CONTEXT = 8;

	public final EntryKeyStore keyStore;
	public final StringContextMode contextMode;
	private long timeStampDiff;
	
	public HttpProjectMemory (Properties propList)  {
		super (propList);
		keyStore = new EntryKeyStore (propList); logMessage("struct", "Storing properties as " + keyStore);
		contextMode = StringContextMode.forProperties (propList, 1);
		logMessage("struct", "Context mode  is " + contextMode);
		try { 
			String serverTime = propList.getProperty("server-time");
			if (serverTime.contains(";")) serverTime = serverTime.substring(0, serverTime.indexOf(';'));
			timeStampDiff = Long.parseLong(serverTime) - System.currentTimeMillis();
			logMessage("", "Server to client timestamp difference: " + timeStampDiff);
		} catch (Exception e) {
			logMessage("", "Cannot find server timestamp : " + e.getMessage());
		}
	}
	
	public org.omegat.core.matching.external.IExternalMemory asTranslationMemory() {
		return new org.silvestrislab.cyclotis.omegat.tm.HttpMemory(this) {
			public List<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
				logMessage("search", "Searching for '" + text + "'");
				List<PrepareTMXEntry> res = httpGetAll("fuzzy", "otadcupniN", reduceWords(text));
				res.removeAll (Collections.singleton(null));
				return res;
			}
			
			public PrepareTMXEntry analyzeLine (HttpOutputFormat fmt, Object args) {
				ContextTMXEntry ctx = HttpProjectMemory.this.analyzeLine(fmt, args);
				if (ctx.entryNum > 0) return null;
				if (args instanceof String[]) {
					String [] cols = (String[]) args;
					cols[8] = cols[9];
				}
				return super.analyzeLine(fmt, args);
				
			}			
		};
	}
		
	public ContextTMXEntry analyzeLine (HttpOutputFormat fmt, Object args) {
		return fmt.buildContextEntry(this, args);
	}
		
	/* ------------------ ProjectMemory.IExternalProjectMemory ---------------*/
	
	public Iterable<ContextTMXEntry> findChanges (long timeStamp) throws Exception {
		logMessage("search", "Searching for segments after " + LONG_LOG_DATE_FORMAT.format(new Date(timeStamp + timeStampDiff)));
		if (timeStamp < 1E9) return httpGetIterable("all", "otadcupni", (new java.sql.Timestamp(timeStamp + timeStampDiff)).toString()); 
		else return httpGetAll("all", "otadcupni", (new java.sql.Timestamp(timeStamp + timeStampDiff)).toString());
	}
	
	protected Map<String,String> encodeArgs (ContextTMXEntry entry) {
		Map<String,String> args = super.encodeArgs(entry);
		args.put("context", contextMode.toDatabase(entry.entryNum, entry.isDefault));
		if (keyStore.shouldWrite(entry))
			for (TMXProp prop: keyStore.buildProperties (entry))
				args.put ("props." + prop.getType(), prop.getValue());
		return args;
	}
		
	public void removeTranslation(ContextTMXEntry entry) throws Exception {
		StringBuffer urlString = new StringBuffer (this.urlSave);
		urlString.append("?context=").append(contextMode.toDatabase(entry.entryNum, entry.isDefault));
		if (! contextMode.isUnique()) urlString.append("&src=").append(URLEncoder.encode(entry.source,"UTF-8"));
		URL httpUrl = new URL (urlString.toString());
		HttpURLConnection connection = (HttpURLConnection) httpUrl.openConnection();  
		connection.setDoOutput(true);
		connection.setDoInput(true);
		connection.setInstanceFollowRedirects(false); 
		connection.setRequestMethod("DELETE");
		
		BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
		String line; while ((line = rd.readLine()) != null) System.out.println("POST:" + line);
		
		connection.disconnect();				
	}
	
	public void registerTranslation(ContextTMXEntry entry) throws Exception {
		logMessage("update", "Writing entry '" + entry.source + "'");
		if (entry.entryNum > 0) 
			entry.otherProperties = store.toDatabase(entry, Core.getProject().getAllEntries().get(entry.entryNum - 1));
		super.registerTranslation(entry);
	}	
}