/**************************************************************************
 Silvestris Cyclotis
 
 Copyright (C) 2014 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is part of Cyclotis plugin for OmegaT
 
 Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/

package org.silvestrislab.cyclotis.omegat.proj.ctx;

import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.SourceTextEntry;


public class FullStringContextMode extends StringContextMode {
	
	public boolean isDefault (String value) {
		return value == null || value.equals("") || value.startsWith("default");
	}
	public boolean isDefault (SourceTextEntry key, String value) {
		return value == null || value.equals("") || value.startsWith("default");
	}

	public boolean isCorrectKey (SourceTextEntry key, String value) {
		return key.getKey().toString().equals(value);
	}

	public String nonDefaultValueForEntry (SourceTextEntry key) {
		return "key:" + key.getKey().toString();
	}
	
	public String defaultValueForSource (String sourceText) {
		return "default:" + sourceText;
	}
	
	protected String convert (String val) {
		return val;
	}
	
	public String toString() {
		return "entryKey.toString";
	}
	
	public boolean isUnique() {
		return true; 
	}
}
