/**************************************************************************
 Silvestris Cyclotis - Intermediate real-time translation memory server
 
 Copyright (C) 2013 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is only a stub to enable compilation of Cyclotis plugin.
 
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/


package org.omegat.core.matching.external;

import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.Language;

/**
 * Interface for external translation memories (MyMemory, ...)
 * 
 * @author Thomas Cordonnier
 */
public interface IExternalMemory {
    /**
     * Get the name of the provider (or engine). <br>
	 * In a project you can have more than one instance of the same engine, in which case all have same result for this method
	 * but a different result in {getMemoryName()}
     */
    String getProviderName();


    /**
     * Get memory name, to replace the file name when displayed inside matches pane.
	 * In a project you can have more than one instance of the same engine, in which case all have same result for {getProviderName()}
	 * but a different result for this method.
     */
    String getMemoryName();
	
    /**
     * Returns matching TMX entries
     * 
     * @param sLang
     *            source language
     * @param tLang
     *            target language
     * @param text
     *            text for translation
	 * @param minScore
     *            the minimum score for a result to be valid (calculated by the provider, should be different from OmegaT's levenstein)
     *            (provided for optimisation purposes, the provider is not required to use this information)
	 * @param maxCount
     *            the maximum results which may be used
     *            (provided for optimisation purposes, the provider is not required to use this information)
     * @return an array of TMX entries, with all necessary info to be displayed in matches pane
     */
    Iterable<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception;
}
