/**************************************************************************
 Silvestris Cyclotis - Intermediate real-time translation memory server
 
 Copyright (C) 2013 Silvestris project (http://www.silvestris-lab.org/)
 
 This file is only a stub to enable compilation of Cyclotis plugin.
 
 You may not use this work except in compliance with the Licence.
 You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

 Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the Licence for the specific language governing permissions and limitations under the Licence. 
 **************************************************************************/


package org.omegat.core.matching.external;

import org.omegat.core.data.TMXEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.util.Language;

/**
 * Defines an updatable translation memory that can override project_save.tmx
 * There should be only zero or one such memory in the project : project_save.properties
 * 
 * @author Thomas CORDONNIER
 */
public class ProjectMemory extends ProjectTMX {

	public static class ContextTMXEntry extends PrepareTMXEntry{
       /** Default constructor: enables field by field setting, as most clients do **/
        public ContextTMXEntry() {        
        }
        
    
        public int entryNum = -1;
        public boolean isDefault;
        public TMXEntry.ExternalLinked linked;
		
	}

	/**
	 * In order to work as ProjectMemory, an updatable external memory needs also a deletion method
	 **/
	public interface IExternalProjectMemory  {
        Iterable<ContextTMXEntry> findChanges (long timeStamp) throws Exception;

        void registerTranslation(ContextTMXEntry entry) throws Exception;
        
        void removeTranslation(ContextTMXEntry entry) throws Exception;
	}

	public interface IConvertibleExternalProjectMemory extends IExternalProjectMemory {
		public IExternalMemory asTranslationMemory() throws Exception;
    }
	
	public ProjectMemory(ProjectTMX base, IExternalProjectMemory memory) {
		super(base);
	}
	
	
}
