
if RUBY_PLATFORM == 'java' then
  require 'culter/ensis/java'
elsif RUBY_ENGINE == 'ironruby'
  require 'culter/ensis/iron'
else
  require 'culter/ensis/gtk2'
end

module Culter::Ensis

  class DebugLine
    def self.cut_debug(culter,segment)
      if not culter.respond_to? 'cut_debug' then
        return culter.cut(segment).map { |item| DebugLine.new("#{item}<A:Simple:") } 
      end
      return culter.cut_debug(segment).split(':true>').map { |item| DebugLine.new(item) }
    end
    def initialize(item)
      @rules = Array.new
      item.gsub!(/<(?:([^>:]+):)?([^>]+):(true|false)>/) do
        @rules << $2
        if $3 == 'true' then '' else '<!>' end
      end
      @phrase = item
      item.sub!(/<(?:([^>]+):)?([^>]+)$/) { @rules << $2; '' }
    end
    def phrase_with_mark(mark = '<!>')
      if mark == '<!>' then return @phrase else return @phrase.gsub('<!>',mark) end
    end
    attr_reader :rules
  end
  
  class Tester
    def create_all_components
      @resultBox = ResultBox.new
      self.add_pane('Text to split', @textBox = TextBox.new(@culter,@resultBox))
      self.add_pane('Result', @resultBox)
    end
  end

  class Editor
    def create_all_components
      self.add_pane('Options', OptionsBox.new(@culter))
      self.add_pane('Rules Mapping', RulesMappingBox.new(self,@culter))
      self.add_pane('Rule templates', TemplatesBox.new(self,@culter))
    end
    def open_test
      lang = input_dialog('Select Language (ISO-639 code): ')
      if lang != nil then 
	Culter::Ensis::Tester.new(Culter::Args::get_segmenter(@culter, lang)).start 
      end
    end
    def do_save(path)
        puts "Saving to #{path}"
        File.open(path, 'w:UTF-8') do |f|
           if path =~ /\.cscx$/i then
               f.puts "<?xml version='1.0' encoding='UTF-8'?>" 
               @culter.to_cscx(f)
           elsif path =~ /\.srx/ then
               f.puts "<?xml version='1.0' encoding='UTF-8'?>" 
               @culter.to_srx(f, '2.0', nil, nil, 'human')
           end
       end
    end
  end
  
  class RulesMappingBox
    def action_add 
      dial = MappingEditDialog.new(@window,@langRules,@mapRule,nil); dial.action!
      if dial.mapping != nil then 
          add_to_view(dial.mapping)
          idx = selectedIndex; idx = 0 if idx < 0 
          @mapRule.insert idx, dial.mapping
      end
    end
    def action_edit 
      dial = MappingEditDialog.new(@window,@langRules,@mapRule,@mapRule[selectedIndex]); dial.action!
      if dial.mapping != nil then 
          @mapRule[selectedIndex] = dial.mapping
          refresh_item(selectedIndex,dial.mapping)
      end
    end
  private
    def ordered_array() '@mapRule' end  
  end
  
  class LangRuleView
    def action_add 
      dial = RuleEditDialog.new(@window,nil); dial.action!
      if dial.rule != nil then 
          add_to_view(dial.rule)
          @langRule << dial.rule
      end
    end
    def action_edit 
      rule = @langRule[self.selectedIndex]
      if rule.is_a? Culter::SRX::Rule then
          dial = RuleEditDialog.new(@window,rule); dial.action!
          if dial.rule != nil then @langRule[self.selectedIndex] = dial.rule; refresh_item(self.selectedIndex, dial.rule) end
      elsif rule.is_a? Culter::CSC::ApplyRuleTemplate then
          dial = ApplyTemplateEditDialog.new(@window,rule); dial.action!
         # if dial.rule != nil then @langRule[self.selectedIndex] = dial.rule; refresh_item(self.selectedIndex, dial.rule) end
      end 
    end
  private
    def ordered_array() '@langRule' end
  end
  
  class TemplatesBox
    def action_add 
      dial = RuleEditDialog.new(@window,nil); dial.action!
      if dial.rule != nil then 
	add_to_view(dial.rule)
	@map[dial.rule.ruleName] = Culter::CSC::RuleTemplate.new(dial.rule.ruleName)
	@map[dial.rule.ruleName].rewriteRule = dial.rule
      end
    end
    def action_edit 
      dial = RuleEditDialog.new(@window,@map[self.selectedItem]); dial.action!
      if dial.rule != nil then 
	@map[dial.rule.ruleName].rewriteRule = dial.rule
      end
    end
  private
    def ordered_array() nil end
  end
end

