#! /usr/bin/env ruby 

formatOptions = {}
ARGV.each { |item| formatOptions[$1] = $2 if item =~ /^--fmt:([\w\-]+)=(.+)$/ }
ARGV.reject! { |item| item =~ /^--fmt:([\w\-]+)=(.+)$/ }

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

if ARGV.count < 3
    puts "Syntax: sg_fromXliff.rb [--fmt:option=value]{0,*} <xliff file> <native original> <native target>"
    exit
end

xliff_file = ARGV.shift
native_ori = ARGV.shift
native_target = ARGV.shift

require 'spongiae/xliff'
translations_map = Spongiae::XLIFF::read_translations_map(xliff_file)
puts "Translations done: #{translations_map.count}"

require 'spongiae/formats/all'

ext = $1 if native_ori =~ /\.(\w+)$/
fmt = Spongiae::Formats::ALL[ext].sniff native_ori
fmt.load!
ori_reader = fmt.create(native_ori)
ori_reader.translate(native_target,translations_map,formatOptions)

